package de.viguard;

import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletionStage;

import javax.swing.Timer;

import javafx.application.Application;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Alert.AlertType;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar.ButtonData;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class HelpMain extends Application implements ActionListener {

	private static Alert alert;
	private static ActionListener listener;
	private static Dialog dialog;
	
	private Stage stage;

	public static void main( String[] args ) throws InterruptedException {

		launch( args );

	}

	@Override
	public void start( Stage primaryStage ) throws Exception {

		listener = this;
		stage = primaryStage;
		stage.setTitle( "Help Dialog" );
		var button = new Button();
		button.setText( "Help!" );
		button.setOnAction( new EventHandler< ActionEvent >() {
			@Override
			public void handle( ActionEvent event ) {
				System.out.println( "'Help!' pressed." );
//					var pane = (DialogPane) FXMLLoader.load( getClass().getClassLoader().getResource( "viGuard_HelpDialog.fxml" ) );
				dialog = new Dialog();
				dialog.setTitle( "Dialer" );
				HttpHelper.post( "/sip/call", "sip", "" );
//				System.out.println( "Call command send." );
				dialog.setHeaderText( "Init..." );
				var timer = new Timer( 1000, listener );
				timer.setRepeats( true );
				timer.start();
				var buttonClose = new ButtonType( "Close", ButtonData.CANCEL_CLOSE );
				dialog.getDialogPane().getButtonTypes().addAll( buttonClose );
				dialog.initOwner( stage );
				dialog.showAndWait();
				timer.stop();
				HttpHelper.post( "/sip/abort", "sip", "" );
//				System.out.println( "Abort command send." );
//				alert = new Alert( AlertType.INFORMATION );
////				alert.setTitle( resourcesMap.get( "HelpDialog" ).getString( "title" ));
//				alert.setTitle( "viGuard Help" );
//				alert.setHeaderText( "Header Text" );
////				alert.setContentText( resourcesMap.get( "HelpDialog" ).getString( "label.text" ) );
//				alert.getButtonTypes().setAll( buttonClose );
//				alert.initOwner( stage );
//				alert.showAndWait();
			}
		} );
		var pane = new StackPane();
		pane.getChildren().add( button );
		stage.setScene( new Scene( pane, 800, 600 ));
//		stage.setFullScreen( true );
		stage.show();
		
	}

//	public void startWatchdog( ActionListener listener ) { startWatchdog( defaultCountdown, listener ); }
//	
//	public void startWatchdog( int timeout, ActionListener listener ) {
//		defaultCountdown = timeout;
//		countdown = timeout;
//		if( watchdogTimer == null ) watchdogTimer = new Timer( 1000, listener );
//		watchdogTimer.setRepeats( true );
//		watchdogTimer.start();
//	}
//	
//	public void stopWatchdog() { watchdogTimer.stop(); }
//	
//	public void restartWatchdog() { restartWatchdog( defaultCountdown ); }
//	
//	public void restartWatchdog( int timeout ) {
//		countdown = timeout;
//	}
	
	@Override
	public void actionPerformed( java.awt.event.ActionEvent e ) {
		var response = HttpHelper.post( "/sip/status", "sip", "" );
		System.out.println( "Response: " + response.body().toString());
		Platform.runLater( () -> dialog.setHeaderText( response.body().toString() ));
	}
}
