package de.viguard;

import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;

import org.json.JSONObject;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;

public class HttpReporter extends ScheduledReporter {

	public HttpReporter( MetricRegistry registry ) {
		super( registry, "http-reporter", MetricFilter.ALL, TimeUnit.SECONDS, TimeUnit.MILLISECONDS );
	}

	@Override
	public void report( SortedMap< String, Gauge > gauges, SortedMap< String, Counter > counters, SortedMap< String, Histogram > histograms, SortedMap< String, Meter > meters, SortedMap< String, Timer > timers ) {

		var json = new JSONObject();
		
//		if( !gauges.isEmpty()){
//            printWithBanner("-- Gauges", '-');
//            for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
//                output.println(entry.getKey());
//                printGauge(entry.getValue());
//            }
//            output.println();
//        }
//
//        if (!counters.isEmpty()) {
//            printWithBanner("-- Counters", '-');
//            for (Map.Entry<String, Counter> entry : counters.entrySet()) {
//                output.println(entry.getKey());
//                printCounter(entry);
//            }
//            output.println();
//        }
//
//        if (!histograms.isEmpty()) {
//            printWithBanner("-- Histograms", '-');
//            for (Map.Entry<String, Histogram> entry : histograms.entrySet()) {
//                output.println(entry.getKey());
//                printHistogram(entry.getValue());
//            }
//            output.println();
//        }
//
        if( !meters.isEmpty()){
        	var jsonMeters = new JSONObject();
            for( Map.Entry<String, Meter> entry : meters.entrySet()){
            	jsonMeters.put( entry.getKey(), entry.getValue());
            }
            json.put( "meters", jsonMeters );
        }

        if (!timers.isEmpty()) {
        	var jsonTimers = new JSONObject();
            for( Map.Entry<String, Timer> entry : timers.entrySet()){
            	jsonTimers.put( entry.getKey(), entry.getValue().getSnapshot().getMean() );
            }
            json.put( "timers", jsonTimers );
        }

		HttpHelper.post( "/metrics", "metrics", json.toString( 1 ));
	}

}
