package de.viguard;

import java.util.HashMap;
import java.util.Properties;
import javafx.application.Platform;

import org.json.JSONArray;
import org.json.JSONObject;

public class PropertiesMain {

	public static void main( String[] args ) {

		var propertyMap = new HashMap<String,PropertiesResourceBundle>();
		var response = HttpHelper.get( "/properties", "new" );
		if( response != null )
			if( response.statusCode() == 200 ) {
				System.out.println( (String) response.body() );
				var properties = new JSONArray( (String) response.body() );
				System.out.println( properties.toString( 1 ));
				properties.forEach( property -> {
					System.out.println( "Key: " + ((JSONObject) property).get( "propertyID" ) + " Value: " + ((JSONObject) property).get( "text" ) );
					if( !propertyMap.containsKey( ((JSONObject) property).get( "formID" ) )){
						propertyMap.put( (String) ((JSONObject) property).get( "formID" ), new PropertiesResourceBundle() );
					}
					propertyMap.get( ((JSONObject) property).get( "formID" ) ).add( (String)((JSONObject) property).get( "propertyID" ), (String)((JSONObject) property).get( "text" ) );
				});
			} else {
				System.out.println( "Status-Code: " + response.statusCode() );
				Platform.exit();
			}
		 else {
			 System.out.println( "no response." );
			 Platform.exit();
		 }

	}

}
