package de.viguard;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.ArrayList;

import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

import javafx.geometry.Point2D;

public class Signature {

	private int width, height;
	private ArrayList<Segment> segments = new ArrayList<Segment>();
	private Segment openSegment;

	public Signature( int width, int height ) {
		this.width = width;
		this.height = height;
	}
	
	public Signature( double width, double height ) {
		this.width = (int)width;
		this.height = (int)height;
	}
	
	public int getWidth() {
		return width;
	}
	
	public int getHeight() {
		return height;
	}
	
	public Signature startSegment( Point2D point ) {
		var segment = new Segment( point );
		openSegment = segment;
		segments.add(  segment );
		return this;
	}
	
	public Signature addPoint( Point2D point ) {
		openSegment.addPoint( point );
		return this;
	}
	public Signature endSegment() {
		return this;
	}

	public ArrayList<Segment> getSegments(){
		return segments;
	}
	
	public Segment getLastSegment() {
		return openSegment;
	}
	
	public String getSVG() {
		DOMImplementation domImpl = new GenericDOMImplementation();
		String svgNS = "http://www.w3c.org/2000/svg";
		Document document = domImpl.createDocument( svgNS, "svg", null );
		SVGGeneratorContext ctx = SVGGeneratorContext.createDefault( document );
		ctx.setComment( "Generated by viGuard Signature" );
		SVGGraphics2D svg = new SVGGraphics2D( ctx, false );
		
		svg.drawPolyline( this.getLastSegment().getXPoints(), this.getLastSegment().getYPoints(), this.getLastSegment().getNPoints() );

		boolean useCSS = true;
		try {
//			var out = new OutputStreamWriter( System.out, "UTF-8" );
//			var out = new OutputStreamWriter( new FileOutputStream( "test.svg" ));
			var out = new StringWriter();
			svg.stream( out );
			return out.toString();
//		} catch( UnsupportedEncodingException e1 ) {
//			e1.printStackTrace();
		} catch( SVGGraphics2DIOException e1 ) {
			e1.printStackTrace();
//		} catch( FileNotFoundException e1 ) {
//			e1.printStackTrace();
		}
		return null;
	}
	
	public class Segment{
		
		private Point2D start;
		private ArrayList<Point2D> points;
		private int[] xPoints, yPoints;
		
		private Segment( Point2D start ) {
			this.start = start;
			points = new ArrayList<Point2D>();
		}
		
		private Segment addPoint( Point2D point ) {
			this.points.add( point );
			return this;
		}
		
		public Point2D getStart() {
			return start;
		}
		
		public ArrayList<Point2D> getPoints(){
			return points;
		}
		
		public int[] getXPoints() {
			if( xPoints == null ) {
				xPoints = new int[ points.size()+1 ];
				xPoints[0] = (int) start.getX();
				yPoints = new int[ points.size()+1 ];
				yPoints[0] = (int) start.getY();
				for( int i = 0; i < points.size(); i++ ) {
					xPoints[ i + 1 ] = (int) points.get( i ).getX();
					yPoints[ i + 1 ] = (int) points.get( i ).getY();
				}
//				var xArray = new ArrayList<Integer>();
//				xArray.add( (int) start.getX() );
//				var yArray = new ArrayList<Integer>();
//				yArray.add( (int) start.getY() );
//				points.forEach( point ->{
//					xArray.add( (int) point.getX() );
//					yArray.add( (int) point.getY() );
//				});
			}
			return xPoints;
		}
		
		public int[] getYPoints() {
			return yPoints;
		}
		
		public int getNPoints() {
			return points.size();
		}
	}
}
