package de.viguard;

import java.net.URL;
import java.util.ResourceBundle;

import de.viguard.controller.FXMLController;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.text.Text;

public class TextYesNoController extends FXMLController implements Initializable {

	public static String a12nCode = "CgVdGENxM7tBR7RSvkA4";
	
    @FXML // ResourceBundle that was given to the FXMLLoader
    private ResourceBundle resources;

    @FXML // URL location of the FXML file that was given to the FXMLLoader
    private URL location;

    @FXML // fx:id="button1"
    private Button button1; // Value injected by FXMLLoader

    @FXML // fx:id="button2"
    private Button button2; // Value injected by FXMLLoader

    @FXML // fx:id="label"
    private Label label; // Value injected by FXMLLoader

    @FXML // This method is called by the FXMLLoader when initialization is complete
    void initialize() {
        assert button1 != null : "fx:id=\"button1\" was not injected: check your FXML file 'viGuard Form SplitPane.fxml'.";
        assert button2 != null : "fx:id=\"button2\" was not injected: check your FXML file 'viGuard Form SplitPane.fxml'.";
        assert label != null : "fx:id=\"label\" was not injected: check your FXML file 'viGuard Form SplitPane.fxml'.";

    }
	
	@Override
	public void initialize( URL location, ResourceBundle resources ) {

		System.out.println( this.getClass().getName() + " initialized." );
		if( location != null ) System.out.println( "TextYesNo - location: " + location.toExternalForm() );
		if( resources != null )
			resources.keySet().forEach( r -> System.out.println( r ));
	}

	@FXML
	protected void onAction( ActionEvent event ) {
		System.out.println( "onAction: " + event.toString() );
	}

	@FXML
	protected void onContextMenuRequested( Event event ) {
		System.out.println( "onAction: " + event.toString() );
	}

	@FXML
	protected void onMouseClicked( Event event ) {
		System.out.println( "onAction: " + event.toString() );
	}
}
