package de.viguard.controller;

import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.swing.Timer;

import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import javafx.scene.layout.Pane;

import com.codahale.metrics.MetricRegistry;

import de.viguard.HttpHelper;
import de.viguard.PropertiesResourceBundle;

public class FXMLController{

	private int defaultCountdown = 30;
	private int retryTimeout = 1;
	
	protected static final MetricRegistry metrics = new MetricRegistry();
	protected static volatile Map< String, PropertiesResourceBundle > resourcesMap = new HashMap<String,PropertiesResourceBundle>();
	protected static String sessionID;
	protected static String firstID, firstURL;
	protected static AnchorPane centerPane;
	protected static Button buttonBack, buttonForward;
	protected static Label title;
	protected static volatile int countdown;
	protected static final LinkedList<FXMLController> controllers = new LinkedList<FXMLController>();
	protected static volatile FXMLController activeController;
	protected static volatile FXMLController mainSceneController;
	protected static volatile FXMLController outOfOrderController;
	protected static final Background bgInvalid = new Background( new BackgroundFill( Color.YELLOW, null, null ));
	protected static final Background bgValid = new Background( new BackgroundFill( Color.LIGHTGREEN, null, null ));

	protected Timer watchdogTimer;
	protected Map< String, List<String>> headers;
	protected String nodeID, nextID;
	protected String nodeURL, nextURL;
	protected Stage stage;
//	protected String stylesheet = HttpHelper.baseURL + "/css";
	protected Scene scene;
	protected Pane pane;
	
	public void show() {
		stage.setTitle( "viGuard FXML" );
		stage.setScene( this.getScene() );
//		stage.setMaximized( true );
		stage.setFullScreenExitHint( "" );
		stage.setFullScreen( true );
		stage.show();
	}

//	public void show( Stage stage ) {
//		this.stage = stage;
//		show();
//	}
	
	public void startWatchdog( int timeout ) { startWatchdog( timeout, (ActionListener) this ); }
	
	public void startWatchdog( ActionListener listener ) { startWatchdog( defaultCountdown, listener ); }
	
	public void startWatchdog( int timeout, ActionListener listener ) {
		defaultCountdown = timeout;
		countdown = timeout;
		if( watchdogTimer == null ) watchdogTimer = new Timer( 1000, listener );
		watchdogTimer.setRepeats( true );
		watchdogTimer.start();
	}
	
	public void stopWatchdog() { 
		System.out.println( "Stopping watchdog" );
		watchdogTimer.stop();
	}
	
	public void restartWatchdog() { restartWatchdog( defaultCountdown ); }
	
	public void restartWatchdog( int timeout ) {
		countdown = timeout;
	}
	
	public MetricRegistry getMetrics() {
		return metrics;
	}
	
	public Map< String, PropertiesResourceBundle > getResourcesMap(){
		return FXMLController.resourcesMap;
	}
	
	public FXMLController setResourcesMap( Map< String, PropertiesResourceBundle > resourcesMap ) {
		FXMLController.resourcesMap = resourcesMap;
		return this;
	}
	
	public FXMLController setSessionID( String sessionID ) {
		FXMLController.sessionID = sessionID;
		return this;
	}
	
	public FXMLController setCenterPane( AnchorPane pane ) {
		FXMLController.centerPane = pane;
		return this;
	}
	
	public FXMLController setPane( Pane pane ) {
		this.pane = pane;
		return this;
	}
	
	public FXMLController setNodeID( String nodeID ) {
		this.nodeID = nodeID;
		return this;
	}
	
	public FXMLController setNodeURL( String nodeURL ) {
		this.nodeURL = nodeURL;
		return this;
	}
	
	public FXMLController setNextID( String nextID ) {
		this.nextID = nextID;
		return this;
	}
	
	public FXMLController setNextURL( String nextURL ) {
		this.nextURL = nextURL;
		return this;
	}
	
//	public FXMLController setStage( Stage stage ) {
//		this.stage = stage;
//		return this;
//	}
	
	public FXMLController setHeaders( Map< String, List< String >> headers ) {
		this.headers = headers;
		if( headers.containsKey( "session-id" )) sessionID = headers.get( "session-id" ).get( 0 );
		return this;
	}
	
	public Stage getStage() {
		return stage;
	}
	
	public FXMLController setStage( Stage stage ) {
		this.stage = stage;
		return this;
	}
	
	public Scene getScene() {
		return scene;
	}
	
	public FXMLController setScene( Scene scene ) {
		this.scene = scene;
		return this;
	}
	
	protected void restart() {
		
		try {
			Thread.sleep( retryTimeout * 1000 );
			if( retryTimeout < 100 ) retryTimeout *= 2;
		} catch( InterruptedException e ) {
			e.printStackTrace();
		}
		
		controllers.clear();
		
		var response = HttpHelper.get( "/start", "new" );
		if( response != null ) {
			if( response.statusCode() == 200 ) {
//				if( System.getenv( "ShowFormLoad" ).startsWith( "true" )) System.out.println( (String) response.body() );
				if( response.headers().map().containsKey( "session-id" ) ) {

					this.setHeaders( response.headers().map() )
					.setSessionID( response.headers().map().get( "session-id" ).get( 0 ))
					.setNextID( response.headers().map().get( "next-id" ).get( 0 ))
					.setNextURL( response.headers().map().get( "next-url" ).get( 0 ));
				}
				retryTimeout = 1;
				loadAndStartNextForm( response.headers().map().get( "next-id" ).get( 0 ), response.headers().map().get( "next-url" ).get( 0 ) );
			}
		} else {
			mainSceneController.stopWatchdog();
			outOfOrderController.startWatchdog( 5 );
			Platform.runLater( () -> outOfOrderController.show());
		}
	}

	protected void loadAndStartNextForm( String nextID, String nextURL ) {
		
		var getResponse = HttpHelper.get( nextURL, sessionID );
		if( getResponse != null && getResponse.statusCode() == 200 ) {
//			if( System.getenv( "ShowFormLoad" ).startsWith( "true" )) System.out.println( "Form: " + getResponse.body() );
			System.out.println( "Form: " + getResponse.body() );
			try {
				var fxmlLoader = new FXMLLoader();
				fxmlLoader.setResources( resourcesMap.get( nextID ));
				System.out.println( "loading resources for Node-ID: " + nextID );
				if( fxmlLoader.getResources() == null ) System.out.println( "Resources not found for Node-ID: " + nextID );
				else {
					if( fxmlLoader.getResources().containsKey( "title" ))
						title.setText( fxmlLoader.getResources().getString( "title" ) );
					else title.setText( "" );

				}
				Pane pane = fxmlLoader.load( new ByteArrayInputStream( ( (String) getResponse.body() ).getBytes()) );
				var controller = (FXMLController) fxmlLoader.getController();
				if( controller instanceof FXMLController ) {
					((FXMLController) controller )
						.setResourcesMap( resourcesMap )
						.setPane( pane )
						.setHeaders( getResponse.headers().map() );
					controllers.add( controller );
					activeController = controller;
				}
				AnchorPane.setTopAnchor( pane, 0.0 );
				AnchorPane.setLeftAnchor( pane, 0.0 );
				AnchorPane.setRightAnchor( pane, 0.0 );
				AnchorPane.setBottomAnchor( pane, 0.0 );
				Platform.runLater( () -> centerPane.getChildren().setAll( pane ));

			} catch( IOException e ) {
				e.printStackTrace();
			}
		} else {
			restart();
		}
	}
	
	protected void onActivate() {}
	
	protected void onForward() {}
	
	protected void onFake() {}
}
