package de.viguard.controller;

import java.net.URL;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;

import org.json.JSONObject;

import de.viguard.HttpHelper;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;

public class ImageLabelTimerController extends FXMLController implements Initializable {

	public static String a12nCode = "CgVdGENxM7tBR7RSvkA4";
	
	private Timer timer = new Timer(); 
	
    @FXML // ResourceBundle that was given to the FXMLLoader
    private ResourceBundle resources;

    @FXML // URL location of the FXML file that was given to the FXMLLoader
    private URL location;

	@Override
	public void initialize( URL location, ResourceBundle resources ) {

//		System.out.println( this.getClass().getName() + " initialized." );
//		if( resources != null )
//			resources.keySet().forEach( r -> System.out.println( r ));
//		System.out.println( "Headers: " + headers.toString() );
		timer.schedule( new TimeoutTask(), 20000 );
		buttonBack.setDisable( false );
		buttonBack.setVisible( true );
		buttonForward.setDisable( true );
		buttonForward.setVisible( false );
	}

//	@FXML
//	protected void onAction( ActionEvent event ) {
//		System.out.println( "onAction: " + event.toString() );
//		timer.cancel();
//		var json = new JSONObject();
//		json.put( "action", "buttonPressed" );
//		var postResponse = HttpHelper.post( headers.get( "node-url" ).get( 0 ), headers.get( "session-id" ).get( 0 ), json.toString( 1 ) );
//		System.out.println( "Post-Body: " + postResponse.body());
//
//		loadAndStartNextForm( postResponse.headers().map().get( "next-id" ).get( 0 ), postResponse.headers().map().get( "next-url" ).get( 0 ) );
//	}

	@Override
	protected void onForward() {
//		System.out.println( "ImageLabelTimer: onForward" );
//		System.out.println( "Headers: " + headers.toString() );
		restartWatchdog();
		timer.cancel();
		var json = new JSONObject();
		json.put( "action", "canceled" );
		var postResponse = HttpHelper.post( headers.get( "node-url" ).get( 0 ), headers.get( "session-id" ).get( 0 ), json.toString( 1 ) );
//		System.out.println( "Post-Body: " + postResponse.body());
		if( postResponse != null && postResponse.statusCode() == 200 )
			loadAndStartNextForm( postResponse.headers().map().get( "next-id" ).get( 0 ), postResponse.headers().map().get( "next-url" ).get( 0 ) );
		else restart();
	}
	
	private class TimeoutTask extends TimerTask {

		@Override
		public void run() {
//			System.out.println( "Timeout" );
			timer.cancel();
			Platform.runLater( () -> {
//				System.out.println( "onTimeout" );
				var json = new JSONObject();
				json.put( "action", "timeout" );
				var postResponse = HttpHelper.post( headers.get( "node-url" ).get( 0 ), headers.get( "session-id" ).get( 0 ), json.toString( 1 ) );
//				System.out.println( "Post-Body: " + postResponse.body());

				if( postResponse != null && postResponse.statusCode() == 200 )
					loadAndStartNextForm( postResponse.headers().map().get( "next-id" ).get( 0 ), postResponse.headers().map().get( "next-url" ).get( 0 ) );
				else restart();
			});
		}
	}
}
