package de.viguard.controller;

import java.net.URL;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;

import org.json.JSONObject;

import de.viguard.HttpHelper;
import de.viguard.ScreenKeyboard.ScreenKeyboardInternationalMinimal;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class SixInputLabelKeyboardController extends FXMLController implements Initializable {

    @FXML // ResourceBundle that was given to the FXMLLoader
    private ResourceBundle resources;

    @FXML // URL location of the FXML file that was given to the FXMLLoader
    private URL location;

    @FXML
    private VBox vBox;
    
    @FXML
    private StackPane keyboard;
    
    @FXML
    private TextField input1, input2, input3, input4, input5, input6;
    
    @FXML
    private Button button;
    
	@Override
	public void initialize( URL location, ResourceBundle resources ) {

//		System.out.println( this.getClass().getName() + " initialized." );
//		if( location != null ) System.out.println( "InputLabelKeyboard - location: " + location.toExternalForm() );
//		if( resources != null )
//			resources.keySet().forEach( r -> System.out.println( r ));
		
		input1.setBackground( bgInvalid );
		input1.textProperty().addListener( ( observable, oldValue, newValue ) -> {
			restartWatchdog();
//			System.out.println( "" + oldValue + " " + newValue );
			if( newValue.length() > 2 ) input1.setBackground( bgValid );
			else input1.setBackground( bgInvalid );
		});
		input2.setBackground( bgInvalid );
		input2.textProperty().addListener( ( observable, oldValue, newValue ) -> {
			restartWatchdog();
//			System.out.println( "" + oldValue + " " + newValue );
			if( newValue.length() > 2 ) input2.setBackground( bgValid );
			else input2.setBackground( bgInvalid );
		});
		input3.setBackground( bgInvalid );
		input3.textProperty().addListener( ( observable, oldValue, newValue ) -> {
			restartWatchdog();
//			System.out.println( "" + oldValue + " " + newValue );
			if( newValue.length() > 2 ) input3.setBackground( bgValid );
			else input3.setBackground( bgInvalid );
		});
		input4.setBackground( bgInvalid );
		input4.textProperty().addListener( ( observable, oldValue, newValue ) -> {
			restartWatchdog();
//			System.out.println( "" + oldValue + " " + newValue );
			if( newValue.length() > 2 ) input4.setBackground( bgValid );
			else input4.setBackground( bgInvalid );
		});
		input5.setBackground( bgInvalid );
		input5.textProperty().addListener( ( observable, oldValue, newValue ) -> {
			restartWatchdog();
//			System.out.println( "" + oldValue + " " + newValue );
			if( newValue.length() > 2 ) input5.setBackground( bgValid );
			else input5.setBackground( bgInvalid );
		});

	    var screenKeyboard = new ScreenKeyboardInternationalMinimal();
	    
	    // just add a border to easily visualize the boundary of the keyboard:
	    screenKeyboard.view().setStyle("-fx-border-color: darkblue; -fx-border-radius: 5;");
	    
	    keyboard.getChildren().add( screenKeyboard.view() );

	    Timer timer = new Timer();
		timer.schedule( new TimerTask() {
			public void run() {
//				System.out.println( "Timer: " + Thread.currentThread().toString());
				timer.cancel();
				Platform.runLater( () -> input1.requestFocus());
			}
		}, 1000 );
		buttonBack.setDisable( false );
		buttonBack.setVisible( true );
		buttonForward.setDisable( false );
		buttonForward.setVisible( true );
	}

	@FXML
	protected void onAction( ActionEvent event ) {
//		System.out.println( "onAction: " + event.toString() );
//		System.out.println( "Input1: " + input1.getText());
	}
	
	@FXML
	public void onChange1( Event event ) {
//		System.out.println( "Event: " + event.toString() );
	}
	
	@FXML
	private void onChange2( Event event ) {
//		System.out.println( "Event: " + event.toString() );
	}
	
	@FXML
	private void onChange3( Event event ) {
//		System.out.println( "Event: " + event.toString() );
	}
	
	@FXML
	private void onChange4( Event event ) {
//		System.out.println( "Event: " + event.toString() );
	}
	
	@FXML
	private void onChange5( Event event ) {
//		System.out.println( "Event: " + event.toString() );
	}
	
	@FXML
	private void onChange6( Event event ) {
//		System.out.println( "Event: " + event.toString() );
	}
	
	@Override
	protected void onForward() {
		restartWatchdog();
//		System.out.println( "6InputLabelKeyboard: onForward" );
		boolean valid = true;
		if( input1.getText().length() < 2 ){
			valid = false;
			input1.setBackground( bgInvalid );
		}
		if( input2.getText().length() < 2 ){
			valid = false;
			input2.setBackground( bgInvalid );
		}
		if( input3.getText().length() < 2 ){
			valid = false;
			input3.setBackground( bgInvalid );
		}
		if( input4.getText().length() < 2 ){
			valid = false;
			input4.setBackground( bgInvalid );
		}
		if( input5.getText().length() < 2 ){
			valid = false;
			input5.setBackground( bgInvalid );
		}
		if( valid ) {
			var json = new JSONObject()
					.put( "input1", input1.getText() )
					.put( "input2", input2.getText() )
					.put( "input3", input3.getText() )
					.put( "input4", input4.getText() )
					.put( "input5", input5.getText() )
					.put( "input6", input6.getText() );
	
			var postResponse = HttpHelper.post( headers.get( "node-url" ).get( 0 ), headers.get( "session-id" ).get( 0 ), json.toString( 1 ) );
			if( postResponse != null && postResponse.statusCode() == 200 )
				loadAndStartNextForm( postResponse.headers().map().get( "next-id" ).get( 0 ), postResponse.headers().map().get( "next-url" ).get( 0 ) );
			else restart();
		}
	}
	
//	@FXML
//	protected void onFake() {
//		input1.setText( "Max" );
//		input2.setText( "Mustermann" );
//		input3.setText( "+491234567890" );
//		input4.setText( "viGuard GmbH" );
//		input5.setText( "RA MM 123" );
//		input6.setText( "RA MM 1234" );
//	}
}
