package de.viguard.distribution;

import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

public class PicturesMain {

	public static void main( String[] args ) {

		int imageWidth = 250;
		int imageHeight = 150;
		
		var image = new BufferedImage( imageWidth, imageHeight, BufferedImage.TYPE_BYTE_BINARY );
		var graphics = image.createGraphics();
//		graphics.setBackground( Color.GRAY );
//		graphics.clearRect( 0, 0, 249, 149 );
		graphics.setColor( Color.GRAY );
		graphics.setFont( new Font( "Arial", Font.PLAIN, 120 ));
		var metrics = graphics.getFontMetrics();
		char[] chars = { 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z' };
		for( char c: chars ) {
			for( int i = 0; i <= 9; i++ ) {
				String text;
				if( i == 0 ) {
					text = String.valueOf( c );
				} else {
					text = String.valueOf( c ) + i;
				}
				
				var width = metrics.stringWidth( text );
				var height = metrics.getAscent();
				System.out.println( "Width: " + width + " Height: " + height );
				
				graphics.clearRect( 0,  0, imageWidth, imageHeight );
				graphics.drawString( text, ( imageWidth - width ) / 2, ( imageHeight - height ) / 2 + height );

				var file = new File( "img-" + text + ".png" );
				try {
					ImageIO.write( image, "png", file );
				} catch (IOException e1) {
					e1.printStackTrace();
				}
			}
		}
	}

}
