package de.viguard.distribution;

import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpResponse.BodyHandlers;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.stream.Stream;

public class UploadFXML {
	
	static String baseURL = "http://localhost:1881/upload/fxml/";

	public static void main( String[] args ) {
		
		try( Stream<Path> stream = Files.walk( Paths.get( "./src/main/resources" ))){
			stream
				.filter( Files::isRegularFile )
				.filter( path -> path.getFileName().toString().endsWith( ".fxml" ) )
				.forEach( path -> {
					System.out.println( path.getFileName());
					uploadFile( path );
				});
		} catch( IOException e1 ) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
	}
	
	public static void uploadFile( Path file ) {
		
		HttpRequest httpRequest;
		HttpClient httpClient;
		HttpResponse<String> httpResponse;
		
		try {
			System.out.println( "PUT: " + baseURL + file.getFileName().toString() );
			httpRequest = HttpRequest.newBuilder( new URI( baseURL + file.getFileName().toString() ) )
					.version( HttpClient.Version.HTTP_1_1 )
					.header( "filename", file.getFileName().toString() )
					.header( "package", "com.viGuard" )
					.PUT( HttpRequest.BodyPublishers.ofFile( file ))
					.build();
			httpClient = HttpClient.newBuilder().build();
			httpResponse = httpClient.send( httpRequest, BodyHandlers.ofString() );
			System.out.println( "Status: " + httpResponse.statusCode());
			httpResponse.headers().map().forEach(( k, v ) -> System.out.println( k + ": " + v ));
		} catch( ConnectException e ) {
			System.out.println( "no connection." );
		} catch( URISyntaxException e ) {
			e.printStackTrace();
		} catch( IOException e ) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch( InterruptedException e ) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}
