package de.viguard;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

import javax.imageio.ImageIO;

import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;

import javafx.application.Application;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.stage.Stage;

public class CanvasMain extends Application {

	public static void main( String[] args ) {
		launch( args );

	}

	@Override
	public void start( Stage stage ) throws Exception {

		var signature = new Signature( 600, 200 );
		var root = new Group();
		var canvas = new Canvas( 600, 200 );
		var context = canvas.getGraphicsContext2D();
		context.setFill( Color.BLACK );
		context.setStroke( Color.BLACK );
		context.setLineWidth( 2.0 );
//		canvas.addEventHandler( MouseEvent.ANY, e -> {
//			System.out.println( "Event: " + e.getEventType() + " X: " + e.getX() + " Y: " + e.getY() );
//		});
		canvas.addEventHandler( MouseEvent.MOUSE_PRESSED, e -> {
			signature.startSegment( new Point2D( e.getX(), e.getY() ));
		} );
		canvas.addEventHandler( MouseEvent.MOUSE_DRAGGED, e -> {
			signature.addPoint( new Point2D( e.getX(), e.getY() ));
			context.clearRect( 0, 0, canvas.getWidth(), canvas.getHeight() );
			var segments = signature.getSegments();
			segments.forEach( segment -> {
				context.beginPath();
				context.moveTo( segment.getStart().getX(), segment.getStart().getY() );
				segment.getPoints().forEach( point -> {
					context.lineTo( point.getX(), point.getY() );
				});
				context.stroke();
			});
		} );
		canvas.addEventHandler( MouseEvent.MOUSE_RELEASED, e -> {
			signature.endSegment();

			System.out.println( signature.getSVG());
			
//			DOMImplementation domImpl = new GenericDOMImplementation();
//			String svgNS = "http://www.w3c.org/2000/svg";
//			Document document = domImpl.createDocument( svgNS, "svg", null );
//			SVGGeneratorContext ctx = SVGGeneratorContext.createDefault( document );
//			ctx.setComment( "Generated by viGuard Signature" );
//			SVGGraphics2D svg = new SVGGraphics2D( ctx, false );
//			
//			svg.drawPolyline( signature.getLastSegment().getXPoints(), signature.getLastSegment().getYPoints(), signature.getLastSegment().getNPoints() );
//
//			boolean useCSS = true;
//			try {
////				var out = new OutputStreamWriter( System.out, "UTF-8" );
//				var out = new OutputStreamWriter( new FileOutputStream( "test.svg" ));
//				svg.stream( out );
////			} catch( UnsupportedEncodingException e1 ) {
////				e1.printStackTrace();
//			} catch( SVGGraphics2DIOException e1 ) {
//				e1.printStackTrace();
//			} catch( FileNotFoundException e1 ) {
//				e1.printStackTrace();
//			}
			
//			var image = canvas.snapshot( null, null );
//			var file = new File( "Test.png" );
//			try {
//				ImageIO.write( SwingFXUtils.fromFXImage( image, null ), "png", file );
//			} catch (IOException e1) {
//				e1.printStackTrace();
//			}
//			var image = new BufferedImage( signature.getWidth(), signature.getHeight(), BufferedImage.TYPE_BYTE_BINARY );
//			var graphics = image.createGraphics();
//			var lastX = 0.0;
//			var lastY = 0.0;
//			graphics.setBackground( java.awt.Color.WHITE );
//			graphics.clearRect( 0, 0, 599, 199 );
//			graphics.setColor( java.awt.Color.BLACK );
//			signature.getSegments().forEach( segment -> {
//				var start = segment.getStart();
//				var last = start;
//				for( Point2D point: segment.getPoints() ) {
//					graphics.drawLine( (int)last.getX(), (int)last.getY(), (int)point.getX(), (int)point.getY() );
//					last = point;
//				}
//			});
//			var file = new File( "Test.png" );
//			try {
//				ImageIO.write( image, "png", file );
//			} catch (IOException e1) {
//				e1.printStackTrace();
//			}
		} );
		root.getChildren().add( canvas );
		
		stage.setScene( new Scene( root ));
		stage.show();
	}

}
