package de.viguard;

import java.io.ByteArrayInputStream;

import org.json.JSONObject;

import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Scene;
import javafx.stage.Stage;
//import javafx.scene.control.Tab;

public class ClientMain extends Application {
	
	public static String baseURL = "http://localhost:1880";
	public static String sessionID;
	
	@Override
	public void init() {
//		this.getParameters().getUnnamed().forEach( p -> System.out.println( p ));

		var start = new JSONObject( HttpHelper.get( "/fe/start", "new" ).body() );
		System.out.println( start.toString( 1 ) );
		if( start.has( "sessionID" ))
			sessionID = String.valueOf( start.getInt( "sessionID" ));
		else sessionID = "invalid";
		
	}
	
	@Override
	public void start( Stage primaryStage ) throws Exception {
		
		var form = (String) HttpHelper.get( "/fxml/language", sessionID ).body();
		System.out.println( "Form: " + form );
		var fxmlLoader = new FXMLLoader();
		Scene scene = fxmlLoader.load( new ByteArrayInputStream( form.getBytes() ));
//		Scene scene = FXMLLoader.load( getClass().getClassLoader().getResource( "viGuard language selection.fxml" ));
		primaryStage.setTitle( "viGuard FXML" );
		primaryStage.setScene( scene );
		primaryStage.show();
	}

	@Override
	public void stop() {
		
	}
}
