package de.viguard.ScreenKeyboard;

import java.text.NumberFormat;
import java.util.Locale;

import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class ScreenKeyboardMain extends Application {

  @Override
  public void start(Stage primaryStage) {

    final TextField textField = new TextField();
    textField.setOnAction(new EventHandler<ActionEvent>() {
      @Override
      public void handle(ActionEvent event) {
        System.out.println("text field: "+textField.getText());
      }
    });
    final TextArea textArea = new TextArea();
    
    final Button okButton = new Button("OK");
    okButton.setDefaultButton(true);
    okButton.setOnAction(new EventHandler<ActionEvent>() {
      @Override
      public void handle(ActionEvent event) {
        System.out.println("OK Button Pressed!");
      }
    });
    
    final Button cancelButton = new Button("Cancel");
    cancelButton.setCancelButton(true);
    cancelButton.setOnAction(new EventHandler<ActionEvent>() {
      @Override
      public void handle(ActionEvent event) {
        System.out.println("Canceled!");
      }
    });
    
    final CheckBox disabledCheckBox = new CheckBox("Disable");
    
    final HBox buttons = new HBox(5);
    buttons.getChildren().addAll(okButton, cancelButton, disabledCheckBox);
    buttons.setAlignment(Pos.CENTER);

    final VBox root = new VBox(5);
    root.setPadding(new Insets(10));
    Scene scene = new Scene(root);
    
//    ScreenKeyboardGerman vkb = new ScreenKeyboardGerman();
    var vkb = new ScreenKeyboardInternationalMinimal();
//    var vkb = new ScreenKeyboardNumericPhone();
    
    // just add a border to easily visualize the boundary of the keyboard:
    vkb.view().setStyle("-fx-border-color: darkblue; -fx-border-radius: 5;");
    vkb.view().disableProperty().bind(disabledCheckBox.selectedProperty());
    
    root.getChildren().addAll(textField, textArea, buttons, vkb.view());

//    scene.setOnKeyPressed( k -> System.out.println( "KeyCode: " + k.getCode()) );
    
    primaryStage.setScene(scene);
    primaryStage.setX( 2650 );
    primaryStage.setY( 800 );
    primaryStage.show();
    
  }

  public static void main(String[] args) {
    Locale[] locales = Locale.getAvailableLocales();
    for( Locale locale: locales ) {
    	System.out.println( locale.getDisplayCountry());
    }

    launch(args);
    
  }

}