package de.viguard.ScreenKeyboard;

import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;

public class ScreenKeyboardNumericPhone extends ScreenKeyboard {
	private final GridPane root;

	/**
	 * Creates a Virtual Keyboard.
	 * 
	 * @param target The node that will receive KeyEvents from this keyboard. If
	 * target is null, KeyEvents will be dynamically forwarded to the focus owner in
	 * the Scene containing this keyboard.
	 */
	public ScreenKeyboardNumericPhone( ReadOnlyObjectProperty< Node > target ) {
		this.root = new GridPane();
		root.setHgap( 5.0 );
		root.setVgap( 5.0 );
		root.setPadding( new Insets( 10 ) );
		root.setGridLinesVisible( true );
		root.getStyleClass().add( "virtual-keyboard" );

		final Modifiers modifiers = new Modifiers();

		root.add( createNonshiftableButton( "1", KeyCode.DIGIT1, modifiers, target ), 0, 0, 1, 1 );
		root.add( createNonshiftableButton( "2", KeyCode.DIGIT2, modifiers, target ), 1, 0, 1, 1 );
		root.add( createNonshiftableButton( "3", KeyCode.DIGIT3, modifiers, target ), 2, 0, 1, 1 );
		root.add( createNonshiftableButton( "4", KeyCode.DIGIT4, modifiers, target ), 0, 1, 1, 1 );
		root.add( createNonshiftableButton( "5", KeyCode.DIGIT5, modifiers, target ), 1, 1, 1, 1 );
		root.add( createNonshiftableButton( "6", KeyCode.DIGIT6, modifiers, target ), 2, 1, 1, 1 );
		root.add( createNonshiftableButton( "7", KeyCode.DIGIT7, modifiers, target ), 0, 2, 1, 1 );
		root.add( createNonshiftableButton( "8", KeyCode.DIGIT8, modifiers, target ), 1, 2, 1, 1 );
		root.add( createNonshiftableButton( "9", KeyCode.DIGIT9, modifiers, target ), 2, 2, 1, 1 );
		root.add( createNonshiftableButton( "*", KeyCode.STAR, modifiers, target ), 0, 3, 1, 1 );
		root.add( createNonshiftableButton( "0", KeyCode.DIGIT0, modifiers, target ), 1, 3, 1, 1 );
		root.add( createNonshiftableButton( "#", KeyCode.NUMBER_SIGN, modifiers, target ), 2, 3, 1, 1 );

		for( int col = 0; col < 3; col++ ) {
			var columnConstraint = new ColumnConstraints();
			columnConstraint.setPercentWidth( 100 / 3 );
			columnConstraint.setFillWidth( true );
			root.getColumnConstraints().add( columnConstraint );
		}
		for( int row = 0; row < 4; row++ ) {
			var rowConstraint = new RowConstraints();
			rowConstraint.setPercentHeight( 100 / 4 );
			rowConstraint.setFillHeight( true );
			root.getRowConstraints().add( rowConstraint );
		}

	}

	/**
	 * Creates a VirtualKeyboard which uses the focusProperty of the scene to which
	 * it is attached as its target
	 */
	public ScreenKeyboardNumericPhone() {
		this( null );
	}

	/**
	 * Visual component displaying this keyboard. The returned node has a style
	 * class of "virtual-keyboard". Buttons in the view have a style class of
	 * "virtual-keyboard-button".
	 * 
	 * @return a view of the keyboard.
	 */
	public Node view() {
		return root;
	}

}