package de.viguard.distribution;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.StringReader;
import java.io.ByteArrayOutputStream;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpResponse.BodyHandlers;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

import javax.imageio.stream.FileImageOutputStream;

import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;

import com.github.mustachejava.MustacheFactory;

import de.viguard.HttpHelper;

import com.github.mustachejava.DefaultMustacheFactory;

/**
 * Reads all SVG-Template files from resources/icons recursively, generates PNGs, uploads or saves them. 
 * 
 * @author Till Uhde
 *
 */

public class GeneratePNGs extends PictureGenerator{

	//static String baseURL = "http://localhost:1880/upload/png/";
	static String basePath = "./src/main/resources/icons/";
	static String destinationPath = "./src/main/resources/png/";

//	static Map<String,String> themes = Map.of( "default", "Test" );
//	static Map<String,String> theme = Map.of(
//			"stroke-color", "black",
//			"fill-color", "grey",
//			"accent-color", "orange"
//		);

	public static void main( String[] args ) {

		if( args.length == 1 ) HttpHelper.baseURL = args[0];

		final MustacheFactory mustacheFactory = new DefaultMustacheFactory();

//		HttpHelper.delete( "/png" );
		
		try( Stream< Path > stream = Files.walk( Paths.get( basePath ) ) ) {
			stream
				.filter( Files::isRegularFile )
				.filter( path -> path.getFileName().toString().endsWith( ".svgt" ) )
				.forEach( path -> {
					System.out.println( path.toString() );
					var setID = path.toString().replaceFirst( basePath, "" ).replace( "/" + path.getFileName().toString(), "" );
//					setID = setID.substring( 0, setID.indexOf( path.getFileName().toString() ) -1 );
					var imageID = path.getFileName().toString().replace( ".svgt", "" );
					System.out.println( "Set: " + setID + " Image: " + imageID );
//						uploadFile( path );
//					HttpHelper.put( "/png/" + path.getFileName().toString(), "..." );
//					convertFile( path );
					try( var fileReader = new FileReader( path.toString() )) {
						var mustache = mustacheFactory.compile( fileReader, path.getFileName().toString() );
						themes.forEach( ( name, theme ) -> {
							try {
								var writer = new StringWriter();
								mustache.execute( writer, theme ).flush();
								var imageBase64 = convertSVGtoPNG( writer.toString());
//								HttpHelper.putPNG( setID, name, imageID, imageBase64 );
								convertSVGtoPNGFile( writer.toString(), destinationPath + setID + "/" + name + "/" + imageID + ".png" );
							} catch( IOException e ) {
								e.printStackTrace();
							}
//							System.out.println( "SVG: " + writer.toString());
//							convertFile( path );
						});
					} catch( FileNotFoundException e ) {
						e.printStackTrace();
					} catch( IOException e1 ) {
						e1.printStackTrace();
					}
				} );
		} catch( IOException e1 ) {
			e1.printStackTrace();
		}
	}

	public static void convertSVGtoPNGFile( String svg, String filename ) {
		var outputStream = new ByteArrayOutputStream();
		try {
//			System.out.println( "SVG: " + svg );
			var input = new TranscoderInput( new StringReader( svg ) );
			var output = new TranscoderOutput( Files.newOutputStream( Path.of( filename ) ) );
			var transcoder = new PNGTranscoder();
			transcoder.transcode( input, output );
		} catch( TranscoderException e ) {
			e.printStackTrace();
		} catch( IOException e ) {
			e.printStackTrace();
		}
	}

	public static String convertSVGtoPNG( String svg ) {
		var outputStream = new ByteArrayOutputStream();
		try {
//			System.out.println( "SVG: " + svg );
			var input = new TranscoderInput( new StringReader( svg ) );
//			var output = new TranscoderOutput( Files.newOutputStream( Path.of( "test.png" ) ) );
			var output = new TranscoderOutput( outputStream );
			var transcoder = new PNGTranscoder();
			transcoder.transcode( input, output );
			return Base64.getEncoder().encodeToString( outputStream.toByteArray() );
		} catch( TranscoderException e ) {
			e.printStackTrace();
		}
		return null;
	}

//	public static void uploadFile( Path file ) {
//
//		HttpRequest httpRequest;
//		HttpClient httpClient;
//		HttpResponse< String > httpResponse;
//
//		try {
//			System.out.println( "PUT: " + HttpHelper.baseURL + file.getFileName().toString() );
//			httpRequest = HttpRequest
//					.newBuilder( new URI( HttpHelper.baseURL + file.getFileName().toString() ) )
//					.version( HttpClient.Version.HTTP_1_1 )
//					.header( "filename", file.getFileName().toString() )
//					.header( "package", "com.viGuard" )
//					.PUT( HttpRequest.BodyPublishers.ofFile( file ) )
//					.build();
//			httpClient = HttpClient.newBuilder().build();
//			httpResponse = httpClient.send( httpRequest, BodyHandlers.ofString() );
//			System.out.println( "Status: " + httpResponse.statusCode() );
//			httpResponse.headers().map().forEach( ( k, v ) -> System.out.println( k + ": " + v ) );
//		} catch( ConnectException e ) {
//			System.out.println( "no connection." );
//		} catch( URISyntaxException e ) {
//			e.printStackTrace();
//		} catch( IOException e ) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		} catch( InterruptedException e ) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
//	}

}
