/*
 * Decompiled with CFR 0.152.
 */
package de.viguard.ScreenKeyboard;

import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ToggleButton;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;

public abstract class ScreenKeyboard {
    private static Font font = Font.font((String)"Courier New", (FontWeight)FontWeight.BOLD, (double)24.0);
    private Node root;

    public ScreenKeyboard(ReadOnlyObjectProperty<Node> target) {
    }

    public ScreenKeyboard() {
        this(null);
    }

    public Node view() {
        return this.root;
    }

    protected Button createShiftableButton(String unshifted, String shifted, KeyCode code, Modifiers modifiers, ReadOnlyObjectProperty<Node> target) {
        SimpleBooleanProperty letter = new SimpleBooleanProperty(unshifted.length() == 1 && Character.isLetter(unshifted.charAt(0)));
        StringBinding text = Bindings.when((ObservableBooleanValue)modifiers.shiftDown().or((ObservableBooleanValue)modifiers.capsLockOn().and((ObservableBooleanValue)letter))).then(shifted).otherwise(unshifted);
        Button button = this.createButton((ObservableStringValue)text, code, modifiers, target);
        button.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        return button;
    }

    protected Button createNonshiftableButton(String text, KeyCode code, Modifiers modifiers, ReadOnlyObjectProperty<Node> target) {
        SimpleStringProperty textProperty = new SimpleStringProperty(text);
        Button button = this.createButton((ObservableStringValue)textProperty, code, modifiers, target);
        button.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        return button;
    }

    private Button createButton(final ObservableStringValue text, final KeyCode code, final Modifiers modifiers, final ReadOnlyObjectProperty<Node> target) {
        final Button button = new Button();
        button.setFont(font);
        button.textProperty().bind((ObservableValue)text);
        button.setFocusTraversable(false);
        button.getStyleClass().add((Object)"virtual-keyboard-button");
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Node targetNode = target != null ? (Node)target.get() : ScreenKeyboard.this.view().getScene().getFocusOwner();
                if (targetNode != null) {
                    String character = ((String)text.get()).length() == 1 ? (String)text.get() : KeyEvent.CHAR_UNDEFINED;
                    KeyEvent keyPressEvent = ScreenKeyboard.this.createKeyEvent(button, (EventTarget)targetNode, (EventType<KeyEvent>)KeyEvent.KEY_PRESSED, character, code, modifiers);
                    targetNode.fireEvent((Event)keyPressEvent);
                    KeyEvent keyReleasedEvent = ScreenKeyboard.this.createKeyEvent(button, (EventTarget)targetNode, (EventType<KeyEvent>)KeyEvent.KEY_RELEASED, character, code, modifiers);
                    targetNode.fireEvent((Event)keyReleasedEvent);
                    if (character != KeyEvent.CHAR_UNDEFINED) {
                        KeyEvent keyTypedEvent = ScreenKeyboard.this.createKeyEvent(button, (EventTarget)targetNode, (EventType<KeyEvent>)KeyEvent.KEY_TYPED, character, code, modifiers);
                        targetNode.fireEvent((Event)keyTypedEvent);
                    }
                    modifiers.releaseKeys();
                }
            }
        });
        button.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        button.setPrefSize(80.0, 80.0);
        return button;
    }

    private KeyEvent createKeyEvent(Object source, EventTarget target, EventType<KeyEvent> eventType, String character, KeyCode code, Modifiers modifiers) {
        return new KeyEvent(source, target, eventType, character, code.toString(), code, modifiers.shiftDown().get(), modifiers.ctrlDown().get(), modifiers.altDown().get(), modifiers.metaDown().get());
    }

    private Button createCursorKey(KeyCode code, Modifiers modifiers, ReadOnlyObjectProperty<Node> target, Double ... points) {
        Button button = this.createNonshiftableButton("", code, modifiers, target);
        button.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        button.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        return button;
    }

    protected static class Modifiers {
        private final ToggleButton shift = this.createToggle("Shift");
        private final ToggleButton shift2 = this.createToggle("Shift");
        private final ToggleButton ctrl = this.createToggle("Ctrl");
        private final ToggleButton alt = this.createToggle("Alt");
        private final ToggleButton meta = this.createToggle("Meta");
        private final ToggleButton capsLock = this.createToggle("Caps");

        Modifiers() {
            this.shift2.selectedProperty().bindBidirectional((Property)this.shift.selectedProperty());
        }

        private ToggleButton createToggle(String text) {
            ToggleButton tb = new ToggleButton(text);
            tb.setFont(font);
            tb.setFocusTraversable(false);
            tb.getStyleClass().add((Object)"virtual-keyboard-button");
            tb.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
            tb.setPrefSize(80.0, 80.0);
            return tb;
        }

        public Node shiftKey() {
            return this.shift;
        }

        public Node secondShiftKey() {
            return this.shift2;
        }

        public Node ctrlKey() {
            return this.ctrl;
        }

        public Node altKey() {
            return this.alt;
        }

        public Node metaKey() {
            return this.meta;
        }

        public Node capsLockKey() {
            return this.capsLock;
        }

        public BooleanProperty shiftDown() {
            return this.shift.selectedProperty();
        }

        public BooleanProperty ctrlDown() {
            return this.ctrl.selectedProperty();
        }

        public BooleanProperty altDown() {
            return this.alt.selectedProperty();
        }

        public BooleanProperty metaDown() {
            return this.meta.selectedProperty();
        }

        public BooleanProperty capsLockOn() {
            return this.capsLock.selectedProperty();
        }

        public void releaseKeys() {
            this.shift.setSelected(false);
            this.ctrl.setSelected(false);
            this.alt.setSelected(false);
            this.meta.setSelected(false);
        }
    }
}

