/*
 * Decompiled with CFR 0.152.
 */
package de.viguard;

import java.io.StringWriter;
import java.util.ArrayList;
import javafx.geometry.Point2D;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.w3c.dom.Document;

public class Signature {
    private int width;
    private int height;
    private ArrayList<Segment> segments = new ArrayList();
    private Segment openSegment;

    public Signature(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public Signature(double width, double height) {
        this.width = (int)width;
        this.height = (int)height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Signature startSegment(Point2D point) {
        Segment segment;
        this.openSegment = segment = new Segment(point);
        this.segments.add(segment);
        return this;
    }

    public Signature addPoint(Point2D point) {
        this.openSegment.addPoint(point);
        return this;
    }

    public Signature endSegment() {
        return this;
    }

    public ArrayList<Segment> getSegments() {
        return this.segments;
    }

    public Segment getLastSegment() {
        return this.openSegment;
    }

    public String getSVG() {
        GenericDOMImplementation domImpl = new GenericDOMImplementation();
        String svgNS = "http://www.w3c.org/2000/svg";
        Document document = domImpl.createDocument(svgNS, "svg", null);
        SVGGeneratorContext ctx = SVGGeneratorContext.createDefault(document);
        ctx.setComment("Generated by viGuard Signature");
        SVGGraphics2D svg = new SVGGraphics2D(ctx, false);
        svg.drawPolyline(this.getLastSegment().getXPoints(), this.getLastSegment().getYPoints(), this.getLastSegment().getNPoints());
        boolean useCSS = true;
        try {
            StringWriter out = new StringWriter();
            svg.stream(out);
            return out.toString();
        }
        catch (SVGGraphics2DIOException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    public class Segment {
        private Point2D start;
        private ArrayList<Point2D> points;
        private int[] xPoints;
        private int[] yPoints;

        private Segment(Point2D start) {
            this.start = start;
            this.points = new ArrayList();
        }

        private Segment addPoint(Point2D point) {
            this.points.add(point);
            return this;
        }

        public Point2D getStart() {
            return this.start;
        }

        public ArrayList<Point2D> getPoints() {
            return this.points;
        }

        public int[] getXPoints() {
            if (this.xPoints == null) {
                this.xPoints = new int[this.points.size() + 1];
                this.xPoints[0] = (int)this.start.getX();
                this.yPoints = new int[this.points.size() + 1];
                this.yPoints[0] = (int)this.start.getY();
                int i = 0;
                while (i < this.points.size()) {
                    this.xPoints[i + 1] = (int)this.points.get(i).getX();
                    this.yPoints[i + 1] = (int)this.points.get(i).getY();
                    ++i;
                }
            }
            return this.xPoints;
        }

        public int[] getYPoints() {
            return this.yPoints;
        }

        public int getNPoints() {
            return this.points.size();
        }
    }
}

