/*
 * Decompiled with CFR 0.152.
 */
package de.viguard.controller;

import de.viguard.HttpHelper;
import de.viguard.Signature;
import de.viguard.controller.FXMLController;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Point2D;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javax.swing.Timer;

public class ImageLabelSignatureController
extends FXMLController
implements Initializable,
ActionListener {
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private Label label;
    @FXML
    private Canvas canvas;
    private GraphicsContext context;
    private Signature signature;
    private Color background = Color.YELLOW;
    private Timer blinkTimer;
    private int blinker = 0;

    public void initialize(URL location, ResourceBundle resources) {
        this.signature = new Signature(this.canvas.getWidth(), this.canvas.getHeight());
        this.context = this.canvas.getGraphicsContext2D();
        this.context.setFill((Paint)this.background);
        this.context.fillRect(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight());
        this.context.setStroke((Paint)Color.BLACK);
        this.context.setLineWidth(2.0);
        this.canvas.addEventHandler(MouseEvent.MOUSE_PRESSED, e -> {
            this.restartWatchdog();
            System.out.println("Begin of segment.");
            this.signature.startSegment(new Point2D(e.getX(), e.getY()));
            this.background = Color.LIGHTGREEN;
        });
        this.canvas.addEventHandler(MouseEvent.MOUSE_DRAGGED, e -> {
            this.signature.addPoint(new Point2D(e.getX(), e.getY()));
            this.context.clearRect(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight());
            this.context.setFill((Paint)this.background);
            this.context.fillRect(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight());
            this.context.setStroke((Paint)Color.BLACK);
            this.context.setLineWidth(2.0);
            ArrayList<Signature.Segment> segments = this.signature.getSegments();
            segments.forEach(segment -> {
                this.context.beginPath();
                this.context.moveTo(segment.getStart().getX(), segment.getStart().getY());
                segment.getPoints().forEach(point -> this.context.lineTo(point.getX(), point.getY()));
                this.context.stroke();
            });
        });
        this.canvas.addEventHandler(MouseEvent.MOUSE_RELEASED, e -> {
            System.out.println("End of segment.");
            this.signature.endSegment();
        });
        this.blinkTimer = new Timer(1000, this);
        this.blinkTimer.setRepeats(true);
        this.blinkTimer.start();
        buttonBack.setDisable(false);
        buttonBack.setVisible(true);
        buttonForward.setDisable(false);
        buttonForward.setVisible(true);
    }

    @Override
    protected void onForward() {
        this.restartWatchdog();
        this.blinkTimer.stop();
        if (this.signature.getSegments().size() > 0) {
            this.blinkTimer.stop();
            HttpResponse postResponse = HttpHelper.post((String)((List)this.headers.get("node-url")).get(0), (String)((List)this.headers.get("session-id")).get(0), this.signature.getSVG());
            if (postResponse != null && postResponse.statusCode() == 200) {
                this.loadAndStartNextForm(postResponse.headers().map().get("next-id").get(0), postResponse.headers().map().get("next-url").get(0));
            } else {
                this.restart();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.signature.getSegments().size() == 0) {
            if (++this.blinker % 2 == 0) {
                this.context.setFill((Paint)Color.YELLOW);
            } else {
                this.context.setFill((Paint)Color.ORANGE);
            }
            this.context.fillRect(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight());
        } else {
            this.blinkTimer.stop();
        }
    }
}

