/*
 * Decompiled with CFR 0.152.
 */
package de.viguard.controller;

import com.codahale.metrics.Timer;
import de.viguard.HelpActionListener;
import de.viguard.HttpHelper;
import de.viguard.controller.FXMLController;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.http.HttpResponse;
import java.util.ListIterator;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;

public class MainSceneController
extends FXMLController
implements Initializable,
ActionListener {
    private static Stage primaryStage;
    private Dialog helpDialog;
    private Alert alert;
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private Button buttonEscape;
    @FXML
    private Button buttonHelp;
    @FXML
    private Button buttonBack;
    @FXML
    private Button buttonForward;
    @FXML
    private Button buttonEnd;
    @FXML
    private AnchorPane paneCenter;
    @FXML
    private Label labelCountdown;
    @FXML
    private Label title;

    @Override
    public Scene getScene() {
        return this.scene;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FXMLController createScene(Stage stage) {
        Timer timer = metrics.timer("MainScene");
        Timer.Context context = timer.time();
        primaryStage = stage;
        ObservableList screens = Screen.getScreens();
        screens.forEach(screen -> System.out.println("Screen: " + screen.toString()));
        HttpResponse response = HttpHelper.get("/start", "new");
        if (response == null) return null;
        if (response.statusCode() != 200) {
            System.out.println("Status-Code: " + response.statusCode());
            return null;
        }
        if (!response.headers().map().containsKey("session-id")) {
            System.out.println("No Session-ID found.");
            return null;
        }
        FXMLLoader fxmlLoader = new FXMLLoader();
        try {
            Timer.Context contextFXMLLoader = metrics.timer("FXMLLoader").time();
            Scene scene = (Scene)fxmlLoader.load((InputStream)new ByteArrayInputStream(((String)response.body()).getBytes()));
            contextFXMLLoader.stop();
            scene.getStylesheets().add((Object)(HttpHelper.baseURL + "/css"));
            FXMLController controller = (FXMLController)fxmlLoader.getController();
            if (!(controller instanceof FXMLController)) return controller;
            controller.scene = scene;
            mainSceneController = controller;
            controller.setHeaders(response.headers().map()).setSessionID(response.headers().map().get("session-id").get(0)).setNextID(response.headers().map().get("next-id").get(0)).setNextURL(response.headers().map().get("next-url").get(0));
            return controller;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        FXMLController.centerPane = this.paneCenter;
        FXMLController.buttonBack = this.buttonBack;
        FXMLController.buttonForward = this.buttonForward;
        FXMLController.title = this.title;
        this.startWatchdog(this);
    }

    public void loadStart() {
        HttpResponse getResponse = HttpHelper.get(firstURL, sessionID);
        if (getResponse != null && getResponse.statusCode() == 200) {
            try {
                FXMLLoader fxmlLoader = new FXMLLoader();
                Pane pane = (Pane)fxmlLoader.load((InputStream)new ByteArrayInputStream(((String)getResponse.body()).getBytes()));
                FXMLController controller = (FXMLController)fxmlLoader.getController();
                if (controller instanceof FXMLController) {
                    controller.setResourcesMap(resourcesMap).setPane(pane).setHeaders(getResponse.headers().map());
                    controllers.add(controller);
                    activeController = controller;
                }
                AnchorPane.setTopAnchor((Node)pane, (Double)0.0);
                AnchorPane.setLeftAnchor((Node)pane, (Double)0.0);
                AnchorPane.setRightAnchor((Node)pane, (Double)0.0);
                AnchorPane.setBottomAnchor((Node)pane, (Double)0.0);
                centerPane.getChildren().setAll((Object[])new Node[]{pane});
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.restart();
        }
    }

    public void loadHelp(Stage stage) {
        HttpResponse getResponse = HttpHelper.get("/help", sessionID);
        if (getResponse != null && getResponse.statusCode() == 200) {
            System.out.println("Form: " + String.valueOf(getResponse.body()));
            try {
                FXMLLoader fxmlLoader = new FXMLLoader();
                DialogPane dialogPane = (DialogPane)fxmlLoader.load((InputStream)new ByteArrayInputStream(((String)getResponse.body()).getBytes()));
                this.helpDialog = new Dialog();
                this.helpDialog.setDialogPane(dialogPane);
                this.helpDialog.initOwner((Window)stage);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.restart();
        }
    }

    @FXML
    protected void onEscape(javafx.event.ActionEvent event) {
        this.restartWatchdog();
        this.restart();
    }

    @FXML
    protected void onHelp(javafx.event.ActionEvent event) {
        System.out.println("Help Button pressed.");
        this.stopWatchdog();
        Dialog dialog = new Dialog();
        HelpActionListener listener = new HelpActionListener(dialog);
        dialog.setTitle("Dialer");
        HttpHelper.post("/sip/call", "sip", "");
        dialog.setHeaderText("Init...");
        javax.swing.Timer timer = new javax.swing.Timer(1000, listener);
        listener.setTimer(timer);
        timer.setRepeats(true);
        timer.start();
        ButtonType buttonClose = new ButtonType("Close", ButtonBar.ButtonData.CANCEL_CLOSE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{buttonClose});
        dialog.initOwner((Window)primaryStage);
        dialog.showAndWait();
        timer.stop();
        HttpHelper.post("/sip/abort", "sip", "");
        this.startWatchdog(this);
    }

    @FXML
    protected void onBack(javafx.event.ActionEvent event) {
        this.restartWatchdog();
        if (controllers.contains(activeController)) {
            ListIterator iterator = controllers.listIterator(controllers.indexOf(activeController));
            if (iterator.hasPrevious()) {
                System.out.println("Iterator previous: " + iterator.previousIndex());
            }
            if (iterator.hasNext()) {
                System.out.println("Iterator next: " + iterator.nextIndex());
            }
            if (iterator.hasPrevious()) {
                FXMLController controller = (FXMLController)iterator.previous();
                controllers.remove(activeController);
                activeController = controller;
                centerPane.getChildren().setAll((Object[])new Node[]{controller.pane});
            }
        }
    }

    @FXML
    protected void onForward(javafx.event.ActionEvent event) {
        this.restartWatchdog();
        activeController.onForward();
    }

    @FXML
    protected void onEnd(javafx.event.ActionEvent event) {
    }

    @FXML
    protected void onFake(MouseEvent event) {
        this.restartWatchdog();
        activeController.onFake();
    }

    @Override
    public MainSceneController setNextID(String nextID) {
        this.nextID = nextID;
        firstID = nextID;
        return this;
    }

    @Override
    public FXMLController setNextURL(String nextURL) {
        this.nextURL = nextURL;
        firstURL = nextURL;
        return this;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (--countdown > 0) {
            System.out.println("MainScene Rest: " + countdown);
            Platform.runLater(() -> this.labelCountdown.setText("" + countdown));
        } else {
            System.out.println("MainScene Timeout!");
            if (this.alert != null) {
                Platform.runLater(() -> this.alert.close());
            }
            this.restart();
        }
    }
}

