/*
 * Decompiled with CFR 0.152.
 */
package de.viguard.distribution;

import de.viguard.HttpHelper;
import de.viguard.distribution.PictureGenerator;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.stream.Stream;
import javax.imageio.ImageIO;

public class UploadPNGs
extends PictureGenerator {
    static String basePath = "./src/main/resources/png/";

    public static void main(String[] args) {
        if (args.length == 1) {
            HttpHelper.baseURL = args[0];
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Stream<Path> stream = Files.walk(Paths.get(basePath, new String[0]), new FileVisitOption[0]);){
                stream.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(path -> path.getFileName().toString().endsWith(".png")).forEach(path -> {
                    System.out.println(path.toString());
                    String imageID = path.getFileName().toString().replace(".png", "");
                    System.out.println("Image: " + imageID);
                    themes.forEach((name, theme) -> {
                        float roundness = Float.parseFloat((String)theme.get("roundnessFloat"));
                        try {
                            BufferedImage image = ImageIO.read(path.toFile());
                            BufferedImage stretched = new BufferedImage(250, 150, 1);
                            Graphics2D stretchedG2D = stretched.createGraphics();
                            stretchedG2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                            stretchedG2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                            stretchedG2D.drawImage(image, 0, 0, 250, 150, null);
                            stretchedG2D.dispose();
                            int width = 250;
                            int height = 150;
                            BufferedImage output = new BufferedImage(width, height, 2);
                            Graphics2D g2d = output.createGraphics();
                            g2d.setComposite(AlphaComposite.Src);
                            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                            g2d.setColor(Color.WHITE);
                            g2d.fill(new RoundRectangle2D.Float(0.0f, 0.0f, width, height, (float)height * roundness, (float)height * roundness));
                            g2d.setComposite(AlphaComposite.SrcAtop);
                            g2d.drawImage((Image)stretched, 0, 0, null);
                            g2d.dispose();
                            ByteArrayOutputStream content = new ByteArrayOutputStream();
                            ImageIO.write((RenderedImage)output, "png", content);
                            String imageBase64 = Base64.getEncoder().encodeToString(content.toByteArray());
                            HttpHelper.putPNG("_default_", name, imageID, imageBase64);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    });
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }
}

