package de.viguard;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

import org.json.JSONArray;
import org.json.JSONObject;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.jmx.JmxReporter;

import de.viguard.controller.FXMLController;
import de.viguard.controller.MainSceneController;
import de.viguard.controller.OutOfOrderController;
import javafx.application.Application;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Scene;
import javafx.stage.Stage;

public class TerminalMain extends Application {
	
	private static FXMLController mainSceneController;
	private static FXMLController outOfOrderController;
	private static Scene scene;
	
	public static void main( String[] args ) {
		if( args.length == 1 ) HttpHelper.baseURL = args[0];
//		var userPreferences = Preferences.userRoot().node( "viGuard" );
//		var systemPreferences = Preferences.systemRoot().node( "viGuard" );
//		systemPreferences.put( "key", "value" );
//		userPreferences.put( "key", "value" );
		
		if( Platform.isSupported( ConditionalFeature.CONTROLS )) System.out.println( "Controls are supported." );
		if( Platform.isSupported( ConditionalFeature.EFFECT )) System.out.println( "Effects are supported." );
		if( Platform.isSupported( ConditionalFeature.FXML )) System.out.println( "FXML is supported." );
		if( Platform.isSupported( ConditionalFeature.GRAPHICS )) System.out.println( "Graphics is supported." );
//		if( Platform.isSupported( ConditionalFeature.INPUT_METHOD )) System.out.println( "Text Input is supported." );
		if( Platform.isSupported( ConditionalFeature.INPUT_MULTITOUCH )) System.out.println( "Multitouch is supported." );
		if( Platform.isSupported( ConditionalFeature.INPUT_POINTER )) System.out.println( "Pointer Device is supported." );
		if( Platform.isSupported( ConditionalFeature.INPUT_TOUCH )) System.out.println( "Touch is supported." );
		if( Platform.isSupported( ConditionalFeature.MEDIA )) System.out.println( "Media is supported." );
		if( Platform.isSupported( ConditionalFeature.SCENE3D )) System.out.println( "3D is supported." );
		if( Platform.isSupported( ConditionalFeature.SHAPE_CLIP )) System.out.println( "Shape Clipping is supported." );
		if( Platform.isSupported( ConditionalFeature.SWING )) System.out.println( "Swing is supported." );
		if( Platform.isSupported( ConditionalFeature.SWT )) System.out.println( "SWT is supported." );
//		if( Platform.isSupported( ConditionalFeature.TRANSPARENT_WINDOW )) System.out.println( "Transparent Window is supported." );
		if( Platform.isSupported( ConditionalFeature.TWO_LEVEL_FOCUS )) System.out.println( "Two Level Focus is supported." );
//		if( Platform.isSupported( ConditionalFeature.UNIFIED_WINDOW )) System.out.println( "Unified Window is supported." );
		if( Platform.isSupported( ConditionalFeature.VIRTUAL_KEYBOARD )) System.out.println( "Virtual Keyboard is supported." );
		if( Platform.isSupported( ConditionalFeature.WEB )) System.out.println( "Web is supported." );
		launch( args );

	}

	@Override
	public void init() {
		System.out.println( "Initializing. Thread: " + Thread.currentThread().getName() );
//		this.getParameters().getUnnamed().forEach( p -> System.out.println( p ));
	}
	
	@Override
	public void start( Stage primaryStage ) throws Exception {
		System.out.println( "Starting. Thread: " + Thread.currentThread().getName() );

//		outOfOrderController = OutOfOrderController.createScene( primaryStage );
//		System.out.println( "OutOfOrderController: " + outOfOrderController );
		try {
			var fxmlLoader = new FXMLLoader( TerminalMain.class.getClassLoader().getResource( "viGuard_OutOfOrder.fxml" ));
			scene = fxmlLoader.load();
			outOfOrderController = fxmlLoader.getController();
			scene.getStylesheets().add( TerminalMain.class.getClassLoader().getResource( "viGuard_dark.css" ).toExternalForm() );
			outOfOrderController.setScene( scene ).setStage( primaryStage );
		} catch( IOException e ) {
			e.printStackTrace();
		}

		if( ( mainSceneController = MainSceneController.createScene( primaryStage )) != null ){
			if( mainSceneController instanceof MainSceneController ) {
				( (MainSceneController) mainSceneController ).loadStart();
				mainSceneController.setStage( primaryStage ).show();
			}
		} else {
			outOfOrderController.startWatchdog( 5 );
			outOfOrderController.show();
		}
	}

	@Override
	public void stop() {
		System.out.println( "Stopping. Thread: " + Thread.currentThread().getName() );
		if( mainSceneController != null ) mainSceneController.stopWatchdog();
		if( outOfOrderController != null ) outOfOrderController.stopWatchdog();
	}
}
