package de.viguard.controller;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ResourceBundle;

import javax.swing.Timer;

import de.viguard.HttpHelper;
import de.viguard.Signature;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Point2D;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;

public class ImageLabelSignatureController extends FXMLController implements Initializable, ActionListener {

    @FXML // ResourceBundle that was given to the FXMLLoader
    private ResourceBundle resources;

    @FXML // URL location of the FXML file that was given to the FXMLLoader
    private URL location;

    @FXML
    private Label label;
    
    @FXML
    private Canvas canvas;
    private GraphicsContext context;
    private Signature signature;
    private Color background = Color.YELLOW;

    private Timer blinkTimer;
    private int blinker = 0;
    
	@Override
	public void initialize( URL location, ResourceBundle resources ) {

//		System.out.println( this.getClass().getName() + " initialized." );
//		if( location != null ) System.out.println( "InputLabelSignatureButton - location: " + location.toExternalForm() );
//		if( resources != null )
//			resources.keySet().forEach( r -> System.out.println( r ));
		
		signature = new Signature( canvas.getWidth(), canvas.getHeight() );
//		var root = new Group();
//		var canvas = new Canvas( 600, 200 );
		context = canvas.getGraphicsContext2D();
		context.setFill( background );
		context.fillRect( 0, 0, canvas.getWidth(), canvas.getHeight() );
		context.setStroke( Color.BLACK );
		context.setLineWidth( 2.0 );
//		canvas.addEventHandler( MouseEvent.ANY, e -> {
//			System.out.println( "Event: " + e.getEventType() + " X: " + e.getX() + " Y: " + e.getY() );
//		});
		
		canvas.addEventHandler( MouseEvent.MOUSE_PRESSED, e -> {
			restartWatchdog();
			System.out.println( "Begin of segment." );
			signature.startSegment( new Point2D( e.getX(), e.getY() ));
			background = Color.LIGHTGREEN;
		} );
		
		canvas.addEventHandler( MouseEvent.MOUSE_DRAGGED, e -> {
			signature.addPoint( new Point2D( e.getX(), e.getY() ));
			context.clearRect( 0, 0, canvas.getWidth(), canvas.getHeight() );
			context.setFill( background );
			context.fillRect( 0, 0, canvas.getWidth(), canvas.getHeight() );
			context.setStroke( Color.BLACK );
			context.setLineWidth( 2.0 );
			var segments = signature.getSegments();
			segments.forEach( segment -> {
				context.beginPath();
				context.moveTo( segment.getStart().getX(), segment.getStart().getY() );
				segment.getPoints().forEach( point -> {
					context.lineTo( point.getX(), point.getY() );
				});
				context.stroke();
			});
		} );
		
		canvas.addEventHandler( MouseEvent.MOUSE_RELEASED, e -> {
			System.out.println( "End of segment." );
			signature.endSegment();
		} );
		
		blinkTimer = new Timer( 1000, this );
		blinkTimer.setRepeats( true );
		blinkTimer.start();
		
		buttonBack.setDisable( false );
		buttonBack.setVisible( true );
		buttonForward.setDisable( false );
		buttonForward.setVisible( true );
	}

	@Override
	protected void onForward() {
//		System.out.println( "ImageLabelSignature: onForward" );
//		System.out.println( "Headers: " + headers.toString() );
		restartWatchdog();
		blinkTimer.stop();

		if( signature.getSegments().size() > 0 ) {
			blinkTimer.stop();
			var postResponse = HttpHelper.post( headers.get( "node-url" ).get( 0 ), headers.get( "session-id" ).get( 0 ), signature.getSVG() );
//			System.out.println( "Post-Body: " + postResponse.body());
			if( postResponse != null && postResponse.statusCode() == 200 )
				loadAndStartNextForm( postResponse.headers().map().get( "next-id" ).get( 0 ), postResponse.headers().map().get( "next-url" ).get( 0 ) );
			else restart();
		}
	}

	@Override
	public void actionPerformed( ActionEvent e ) {
		if( signature.getSegments().size() == 0 ) {
//			System.out.println( "blinkTimer." );
			if( ++blinker % 2 == 0 ) context.setFill( Color.YELLOW );
			else context.setFill(  Color.ORANGE );
			context.fillRect( 0, 0, canvas.getWidth(), canvas.getHeight() );
		} else {
			blinkTimer.stop();
		}
	}
	
//	@FXML
//	protected void onAction( ActionEvent event ) {
//
//		var postResponse = HttpHelper.post( headers.get( "node-url" ).get( 0 ), headers.get( "session-id" ).get( 0 ), signature.getSVG() );
//		System.out.println( "Post-Body: " + postResponse.body());
//
//		loadAndStartNextForm( postResponse.headers().map().get( "next-id" ).get( 0 ), postResponse.headers().map().get( "next-url" ).get( 0 ) );
//	}
}
