package de.viguard.controller;

import java.net.URL;
import java.util.ResourceBundle;

import org.json.JSONArray;
import org.json.JSONObject;

import de.viguard.HttpHelper;
import de.viguard.PropertiesResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;

public class LanguageSelectionController extends FXMLController implements Initializable {

    @FXML // ResourceBundle that was given to the FXMLLoader
    private ResourceBundle resources;

    @FXML // URL location of the FXML file that was given to the FXMLLoader
    private URL location;

	@FXML
	private Button buttonA1, buttonA2, buttonA3, buttonA4,
		buttonB1, buttonB2, buttonB3, buttonB4,
		buttonC1, buttonC2, buttonC3, buttonC4,
		buttonD1, buttonD2, buttonD3, buttonD4;
	
	@Override
	public void initialize( URL location, ResourceBundle resources ) {

//		System.out.println( this.getClass().getName() + " initialized." );
//		if( location != null ) System.out.println( "LanguageSelection - location: " + location.toExternalForm() );
//		if( resources != null )
//			resources.keySet().forEach( r -> System.out.println( r ));
		buttonBack.setDisable( true );
		buttonBack.setVisible( false );
		buttonForward.setDisable( true );
		buttonForward.setVisible( false );
	}

	@FXML
	protected void onAction( ActionEvent event ) {
		restartWatchdog();
//		System.out.println( "onAction: " + event.toString() );
		var json = new JSONObject();
		json.put( "buttonPressed", ((Button) event.getSource()).getId() );
		var postResponse = HttpHelper.post( headers.get( "node-url" ).get( 0 ), headers.get( "session-id" ).get( 0 ), json.toString( 1 ) );
		if( postResponse != null && postResponse.statusCode() == 200 ){
//			if( System.getenv( "ShowPostResponseBody" ).startsWith( "true" ) ) System.out.println( "Post-Body: " + postResponse.body());
	
			var properties = new JSONArray( (String) postResponse.body() );
//			System.out.println( properties.toString( 1 ));
			resourcesMap.clear();
			properties.forEach( property -> {
//				if( System.getenv( "ShowLoadedProperties" ).startsWith( "true" ) ) System.out.println( "Form: " + ((JSONObject) property).get( "formID" ) + " Key: " + ((JSONObject) property).get( "propertyID" ) + " Value: " + ((JSONObject) property).get( "Text" ) );
				if( !resourcesMap.containsKey( ((JSONObject) property).get( "formID" ) )){
					resourcesMap.put( (String) ((JSONObject) property).get( "formID" ), new PropertiesResourceBundle() );
				}
				resourcesMap.get( ((JSONObject) property).get( "formID" ) ).add( (String)((JSONObject) property).get( "propertyID" ), (String)((JSONObject) property).get( "Text" ) );
			});
			loadAndStartNextForm( postResponse.headers().map().get( "next-id" ).get( 0 ), postResponse.headers().map().get( "next-url" ).get( 0 ) );
		} else restart();
	}
}
