package de.viguard.controller;

import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;

import javax.swing.Timer;

import de.viguard.HelpActionListener;
import de.viguard.HttpHelper;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Alert.AlertType;
import javafx.scene.control.ButtonBar.ButtonData;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.stage.Screen;
import javafx.stage.Stage;

public class OutOfOrderController extends FXMLController implements Initializable, ActionListener {

//	private static Stage primaryStage;

	private Dialog helpDialog;
	private Alert alert;

	@FXML // ResourceBundle that was given to the FXMLLoader
	private ResourceBundle resources;

	@FXML // URL location of the FXML file that was given to the FXMLLoader
	private URL location;

	@FXML
	public void onButtonPressed( ActionEvent event ) {
		System.out.println( "Button pressed." );
	}
	
//	public static FXMLController createScene( Stage stage ) {
//		primaryStage = stage;
//		try {
//			var fxmlLoader = new FXMLLoader( OutOfOrderController.class.getClassLoader().getResource( "viGuard_OutOfOrder.fxml" ));
//			var fxml = OutOfOrderController.class.getClassLoader().getResource( "viGuard_OutOfOrder.fxml" );
//			Scene scene = fxmlLoader.load( fxml );
//			System.out.println( "Controller:" + fxmlLoader.getController() );
//			scene.getStylesheets().add( OutOfOrderController.class.getClassLoader().getResource( "viGuard_dark.css" ).toExternalForm() );
//			outOfOrderController = fxmlLoader.getController();
//			outOfOrderController.scene = scene;
//			return outOfOrderController;
//		} catch( IOException e ) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
//		return null;
//	}

	@Override
	public void initialize( URL location, ResourceBundle resources ) {

		System.out.println( this.getClass().getName() + " initialized." );
		if( location != null ) System.out.println( "MainScene - location: " + location.toExternalForm() );
		if( resources != null ) resources.keySet().forEach( r -> System.out.println( r ) );
		outOfOrderController = this;
//		startWatchdog( 5, this );
	}

	@Override
	public void actionPerformed( java.awt.event.ActionEvent e ) {
		if( --countdown > 0 ) {
			System.out.println( "OutOfOrder Rest: " + countdown );
		} else {
			System.out.println( "OuOfOrder Timeout!" );
			FXMLController mainSceneController;
			if( ( mainSceneController = MainSceneController.createScene( stage )) != null ){
				if( mainSceneController instanceof MainSceneController ) {
					( (MainSceneController) mainSceneController ).loadStart();
					Platform.runLater( () -> mainSceneController.setStage( stage ).show());
					stopWatchdog();
				}
			} else {
				restartWatchdog();
			}
		}
	}
}
