package de.viguard.distribution;

import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpResponse.BodyHandlers;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.stream.Stream;

public class UploadClasses {
	
	static String baseURL = "http://localhost:1880/upload/class/";

	public static void main( String[] args ) {
		
		try( Stream<Path> stream = Files.walk( Paths.get( "./target/classes/" ))){
			stream
				.filter( Files::isRegularFile )
				.filter( path -> path.getFileName().toString().endsWith( ".class" ) )
				.forEach( path -> {
					System.out.println( path.getFileName());
					uploadClassFile( path );
				});
		} catch( IOException e1 ) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
	}
	
	public static void uploadClassFile( Path classFile ) {
		
		HttpRequest httpRequest;
		HttpClient httpClient;
		HttpResponse<String> httpResponse;
	
		System.out.println( "Path: " + classFile.toString() );
		try {
			var uri = new URI( baseURL + classFile.getFileName().toString() );
			System.out.println( "PUT: " + uri );
			httpRequest = HttpRequest.newBuilder( uri )
					.version( HttpClient.Version.HTTP_1_1 )
					.header( "classname", classFile.getFileName().toString() )
					.header( "package", classFile.toString().replaceFirst( "./target/classes/", "" ) )
					.PUT( HttpRequest.BodyPublishers.ofFile( classFile ))
					.build();
			httpClient = HttpClient.newBuilder().build();
			httpResponse = httpClient.send( httpRequest, BodyHandlers.ofString() );
			System.out.println( "Status: " + httpResponse.statusCode());
			httpResponse.headers().map().forEach(( k, v ) -> System.out.println( k + ": " + v ));
		} catch( ConnectException e ) {
			System.out.println( "no connection." );
		} catch( URISyntaxException e ) {
			e.printStackTrace();
		} catch( IOException e ) {
			e.printStackTrace();
		} catch( InterruptedException e ) {
			e.printStackTrace();
		}
	}
}
