package de.viguard.distribution;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.StringReader;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpResponse.BodyHandlers;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageOutputStream;

import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;

import com.github.mustachejava.MustacheFactory;

import de.viguard.HttpHelper;

import com.github.mustachejava.DefaultMustacheFactory;

public class UploadPNGs extends PictureGenerator {

//	static String baseURL = "http://localhost:1880/upload/png/";
	static String basePath = "./src/main/resources/png/";

	public static void main( String[] args ) {

		if( args.length == 1 ) HttpHelper.baseURL = args[0];

		try( Stream< Path > stream = Files.walk( Paths.get( basePath ) ) ) {
			stream.filter( Files::isRegularFile ).filter( path -> path.getFileName().toString().endsWith( ".png" ) ).forEach( path -> {
				System.out.println( path.toString() );
				var imageID = path.getFileName().toString().replace( ".png", "" );
				System.out.println( "Image: " + imageID );
				themes.forEach( ( name, theme ) -> {
					var roundness = Float.parseFloat( theme.get( "roundnessFloat" ));
					try {
						var image = ImageIO.read( path.toFile() );
						var stretched = new BufferedImage( 250, 150, BufferedImage.TYPE_INT_RGB );
						var stretchedG2D = stretched.createGraphics();
						stretchedG2D.setRenderingHint( RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON );
						stretchedG2D.setRenderingHint( RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR );
						stretchedG2D.drawImage( image, 0, 0, 250, 150, null );
						stretchedG2D.dispose();
						var width = 250;
						var height = 150;
						var output = new BufferedImage( width, height, BufferedImage.TYPE_INT_ARGB );
						var g2d = output.createGraphics();
						g2d.setComposite( AlphaComposite.Src );
						g2d.setRenderingHint( RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON );
						g2d.setColor( Color.WHITE );
						g2d.fill( new RoundRectangle2D.Float( 0, 0, width, height, height * roundness, height * roundness ));
						g2d.setComposite( AlphaComposite.SrcAtop );
						g2d.drawImage( stretched, 0, 0, null );
						g2d.dispose();
//						ImageIO.write( output, "png", new File( "./src/main/resources/flags/" + imageID + "-" + name + ".png" ));
						ByteArrayOutputStream content = new ByteArrayOutputStream();
						ImageIO.write( output, "png", content );
						var imageBase64 = Base64.getEncoder().encodeToString( content.toByteArray() );
						HttpHelper.putPNG( "_default_", name, imageID, imageBase64 );
					} catch( IOException e ) {
						e.printStackTrace();
					} 
				});
			} );
		} catch( IOException e1 ) {
			e1.printStackTrace();
		}
	}
}
