package de.viguard;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;

import de.viguard.controller.FXMLController;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.text.Text;

public class ControllerTemplate extends FXMLController implements Initializable {

    @FXML // ResourceBundle that was given to the FXMLLoader
    private ResourceBundle resources;

    @FXML // URL location of the FXML file that was given to the FXMLLoader
    private URL location;

    @FXML // fx:id="button"
    private Button button; // Value injected by FXMLLoader

    @FXML // fx:id="text"
    private Label text; // Value injected by FXMLLoader

    @FXML // This method is called by the FXMLLoader when initialization is complete
    void initialize() {
        assert button != null : "fx:id=\"button\" was not injected: check your FXML file 'viGuard Form Template.fxml'.";
        assert text != null : "fx:id=\"text\" was not injected: check your FXML file 'viGuard Form Template.fxml'.";

    }
	
	@Override
	public void initialize( URL location, ResourceBundle resources ) {

		System.out.println( this.getClass().getName() + " initialized." );
		if( location != null ) System.out.println( "Template - location: " + location.toExternalForm() );
		if( resources != null )
			resources.keySet().forEach( r -> System.out.println( r ));
	}
	
	@FXML
	protected void onAction( ActionEvent event ) {
		System.out.println( "onAction: " + event.toString() );
		var postResponse = HttpHelper.post( headers.get( "node-url" ).get( 0 ), headers.get( "session-id" ).get( 0 ), "" );
		System.out.println( "Post-Body: " + postResponse.body());

		loadAndStartNextForm( postResponse.headers().map().get( "next-id" ).get( 0 ), postResponse.headers().map().get( "next-url" ).get( 0 ) );
	}
}
