package de.viguard;

import java.util.List;

import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;

import de.viguard.controller.FXMLController;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;

public class FXMLTest extends Application {

	@FXML
	public Pane pane;
	
	@FXML
	public Button buttonBack, buttonForward;
	
	public static void main( String[] args ){
		Integer nullNull = null;
		Integer zero = Integer.valueOf( 0 );
		Integer one = Integer.valueOf( 1 );
		
		if( nullNull != null && nullNull == 0 ) System.out.println( "Null" );
		if( zero != null && zero == 0 ) System.out.println( "Zero" );
		launch();
	}

	@Override
	public void init() {
		
		ScriptEngineManager sem = new ScriptEngineManager();
		List<ScriptEngineFactory> lsef = sem.getEngineFactories();
		lsef.forEach( sef -> {
			
			System.out.println( sef.getEngineName() + " Ver.: " + sef.getEngineVersion() + " serving: " + sef.getLanguageName() + " Version: " + sef.getLanguageVersion() );
			sef.getNames().forEach( n -> System.out.println( n ) );

		});
	}

	@Override
	public void start( Stage primaryStage ) throws Exception {

		var resources = new PropertiesResourceBundle()
				.add( "header.text", "Text" )
				.add( "input.prompt", "Text" );
		var loader = new FXMLLoader();
		loader.setResources( resources );
		loader.getResources().keySet().forEach( k -> System.out.println( "Key: " + k ));
		Scene scene = FXMLLoader.load( getClass().getClassLoader().getResource( "viGuard_TerminalMain.fxml" ), resources );
//		scene.getStylesheets().add( "https://viguard.uhde.it/css" );
//		buttonBack.setOnAction( e -> System.out.println( "onBack: " + e.toString()) );
		var controller = (FXMLController) loader.getController();
		if( controller instanceof FXMLController ) {
			System.out.println( "Controller: " + controller );
		}
		
		primaryStage.setTitle( "FXML Test" );
		primaryStage.setScene( scene );
		primaryStage.show();

	}
	
	protected void onBack( ActionEvent event ) {
		System.out.println( "onAction: " + event.toString() );
	}

}


//<fx:script>
//	function handleButtonAction(){
//		button.setText( "Javascript Test" );
//	}
//</fx:script>
