package de.viguard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Timer;

import org.json.JSONObject;

import javafx.application.Platform;
import javafx.scene.control.Dialog;

public class HelpActionListener implements ActionListener {

	private Dialog dialog;
	private Timer timer;
	
	public HelpActionListener( Dialog dialog ) {
		this.dialog = dialog;
	}

	public HelpActionListener setTimer( Timer timer ) {
		this.timer = timer;
		return this;
	}
	
	@Override
	public void actionPerformed( java.awt.event.ActionEvent e ) {
		var response = HttpHelper.post( "/sip/status", "sip", "" );
		var json = new JSONObject( response.body().toString());
		System.out.println( "Response: " + response.body().toString());
		if( json.has( "StatusId" )) {
			System.out.println( "StatusID: " + json.getString( "StatusId" ));
			if( json.has( "StatusText" ))
				Platform.runLater( () -> dialog.setHeaderText( json.getString( "StatusText" )));
			if( json.getString( "StatusId" ).startsWith( "333" )) {
				this.timer.stop();
				Platform.runLater( () -> this.dialog.close());
			}
		}
	}
}
