package de.viguard;

import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpRequest.BodyPublisher;
import java.net.http.HttpResponse;
import java.net.http.HttpResponse.BodyHandlers;
import java.time.Duration;

public class HttpHelper {

	public static String baseURL = "http://localhost:1881";
	private static String authCode = "UnuKJZzH7JPbp8pYvK9H";

	public static HttpResponse get( String url, String sessionID ) {
		
		HttpRequest httpRequest;
		HttpClient httpClient;
		HttpResponse<String> httpResponse;
		
		try {
			System.out.println( "GET: " + baseURL + url + " with SessionID: " + sessionID );
			httpRequest = HttpRequest.newBuilder( new URI( baseURL + url ) )
					.version( HttpClient.Version.HTTP_1_1 )
					.header( "Authentication-Code", authCode )
					.header( "Session-ID", sessionID )
					.GET()
					.timeout( Duration.ofSeconds( 10 ))
					.build();
			httpClient = HttpClient.newBuilder().build();
			httpResponse = httpClient.send( httpRequest, BodyHandlers.ofString() );
			System.out.println( "Status: " + httpResponse.statusCode());
			System.out.println( "Headers:" );
			httpResponse.headers().map().forEach(( k, v ) -> System.out.println( k + ": " + v ));
			return httpResponse;
		} catch( ConnectException e ) {
			System.out.println( "no connection." );
			return null;
		} catch( URISyntaxException e ) {
			e.printStackTrace();
		} catch( IOException e ) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch( InterruptedException e ) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}

	public static HttpResponse post( String url, String sessionID, String body ) {
		
		HttpRequest httpRequest;
		HttpClient httpClient;
		HttpResponse<String> httpResponse;
		
		try {
			System.out.println( "POST: " + baseURL + url + " with SessionID: " + sessionID );
			System.out.println( "Body: " + body );
			httpRequest = HttpRequest.newBuilder( new URI( baseURL + url ) )
					.version( HttpClient.Version.HTTP_1_1 )
					.header( "Authentication-Code", authCode )
					.header( "Session-ID", sessionID )
					.POST( HttpRequest.BodyPublishers.ofString( body ) )
					.timeout( Duration.ofSeconds( 10 ))
					.build();
			httpClient = HttpClient.newBuilder().build();
			httpResponse = httpClient.send( httpRequest, BodyHandlers.ofString() );
			System.out.println( "Status: " + httpResponse.statusCode());
			httpResponse.headers().map().forEach(( k, v ) -> System.out.println( k + ": " + v ));
			return httpResponse;
		} catch( ConnectException e ) {
			System.out.println( "no connection." );
			return null;
		} catch( URISyntaxException e ) {
			e.printStackTrace();
		} catch( IOException e ) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch( InterruptedException e ) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}
	
	public static HttpResponse put( String url, String body ) {
		HttpRequest httpRequest;
		HttpClient httpClient;
		HttpResponse<String> httpResponse;
		
		try {
			System.out.println( "PUT: " + baseURL + url );
			httpRequest = HttpRequest.newBuilder( new URI( baseURL + url ) )
					.version( HttpClient.Version.HTTP_1_1 )
					.header( "Authentication-Code", authCode )
//					.header( "filename", file.getFileName().toString() )
					.header( "package", "com.viGuard" )
					.PUT( HttpRequest.BodyPublishers.ofString( body ))
					.build();
			httpClient = HttpClient.newBuilder().build();
			httpResponse = httpClient.send( httpRequest, BodyHandlers.ofString() );
			System.out.println( "Status: " + httpResponse.statusCode());
			httpResponse.headers().map().forEach(( k, v ) -> System.out.println( k + ": " + v ));
			return httpResponse;
		} catch( ConnectException e ) {
			System.out.println( "no connection." );
		} catch( URISyntaxException e ) {
			e.printStackTrace();
		} catch( IOException e ) {
			e.printStackTrace();
		} catch( InterruptedException e ) {
			e.printStackTrace();
		}
		return null;
	}

	public static HttpResponse delete( String url ) {
		HttpRequest httpRequest;
		HttpClient httpClient;
		HttpResponse<String> httpResponse;
		
		try {
			System.out.println( "DELETE: " + baseURL + url );
			httpRequest = HttpRequest.newBuilder( new URI( baseURL + url ) )
					.version( HttpClient.Version.HTTP_1_1 )
					.header( "Authentication-Code", authCode )
//					.header( "filename", file.getFileName().toString() )
					.header( "package", "com.viGuard" )
//					.PUT( HttpRequest.BodyPublishers.ofString( body ))
					.DELETE()
					.build();
			httpClient = HttpClient.newBuilder().build();
			httpResponse = httpClient.send( httpRequest, BodyHandlers.ofString() );
			System.out.println( "Status: " + httpResponse.statusCode());
			httpResponse.headers().map().forEach(( k, v ) -> System.out.println( k + ": " + v ));
			return httpResponse;
		} catch( ConnectException e ) {
			System.out.println( "no connection." );
		} catch( URISyntaxException e ) {
			e.printStackTrace();
		} catch( IOException e ) {
			e.printStackTrace();
		} catch( InterruptedException e ) {
			e.printStackTrace();
		}
		return null;
	}
	public static HttpResponse putPNG( String setID, String themeID, String imageID, String body ) {
		HttpRequest httpRequest;
		HttpClient httpClient;
		HttpResponse<String> httpResponse;
		
		try {
			System.out.println( "PUT: " + baseURL + "/png/" + imageID );
			httpRequest = HttpRequest.newBuilder( new URI( baseURL + "/png/" + imageID ) )
					.version( HttpClient.Version.HTTP_1_1 )
					.header( "Authentication-Code", authCode )
					.header( "Image-ID", imageID )
					.header( "Set-ID", setID )
					.header( "Theme-ID", themeID )
					.PUT( HttpRequest.BodyPublishers.ofString( body ))
					.build();
			httpClient = HttpClient.newBuilder().build();
			httpResponse = httpClient.send( httpRequest, BodyHandlers.ofString() );
			System.out.println( "Status: " + httpResponse.statusCode());
			httpResponse.headers().map().forEach(( k, v ) -> System.out.println( k + ": " + v ));
			return httpResponse;
		} catch( ConnectException e ) {
			System.out.println( "no connection." );
		} catch( URISyntaxException e ) {
			e.printStackTrace();
		} catch( IOException e ) {
			e.printStackTrace();
		} catch( InterruptedException e ) {
			e.printStackTrace();
		}
		return null;
	}
}
