package de.viguard.ScreenKeyboard;

import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;

public class ScreenKeyboardGerman extends ScreenKeyboard {
	private final GridPane root;

	/**
	 * Creates a Virtual Keyboard.
	 * 
	 * @param target The node that will receive KeyEvents from this keyboard. If
	 * target is null, KeyEvents will be dynamically forwarded to the focus owner in
	 * the Scene containing this keyboard.
	 */
	public ScreenKeyboardGerman( ReadOnlyObjectProperty< Node > target ) {
		this.root = new GridPane();
		root.setHgap( 5.0 );
		root.setVgap( 5.0 );
		root.setPadding( new Insets( 10 ) );
		root.setGridLinesVisible( true );
		root.getStyleClass().add( "virtual-keyboard" );

		final Modifiers modifiers = new Modifiers();

		root.add( createShiftableButton( "^", "°", KeyCode.CIRCUMFLEX, modifiers, target ), 0, 0, 2, 1 );
		root.add( createShiftableButton( "1", "!", KeyCode.DIGIT1, modifiers, target ), 2, 0, 2, 1 );
		root.add( createShiftableButton( "2", "\"", KeyCode.DIGIT2, modifiers, target ), 4, 0, 2, 1 );
		root.add( createShiftableButton( "3", "§", KeyCode.DIGIT3, modifiers, target ), 6, 0, 2, 1 );
		root.add( createShiftableButton( "4", "$", KeyCode.DIGIT4, modifiers, target ), 8, 0, 2, 1 );
		root.add( createShiftableButton( "5", "%", KeyCode.DIGIT5, modifiers, target ), 10, 0, 2, 1 );
		root.add( createShiftableButton( "6", "&", KeyCode.DIGIT6, modifiers, target ), 12, 0, 2, 1 );
		root.add( createShiftableButton( "7", "/", KeyCode.DIGIT7, modifiers, target ), 14, 0, 2, 1 );
		root.add( createShiftableButton( "8", "(", KeyCode.DIGIT8, modifiers, target ), 16, 0, 2, 1 );
		root.add( createShiftableButton( "9", ")", KeyCode.DIGIT9, modifiers, target ), 18, 0, 2, 1 );
		root.add( createShiftableButton( "0", "=", KeyCode.DIGIT0, modifiers, target ), 20, 0, 2, 1 );
		root.add( createShiftableButton( "ß", "?", KeyCode.UNDEFINED, modifiers, target ), 22, 0, 2, 1 );
		root.add( createShiftableButton( "´", "`", KeyCode.UNDEFINED, modifiers, target ), 24, 0, 2, 1 );
		root.add( createNonshiftableButton( "Back", KeyCode.BACK_SPACE, modifiers, target ), 26, 0, 3, 1 );

		root.add( createNonshiftableButton( "Tab", KeyCode.TAB, modifiers, target ), 0, 1, 3, 1 );
		root.add( createShiftableButton( "q", "Q", KeyCode.Q, modifiers, target ), 3, 1, 2, 1 );
		root.add( createShiftableButton( "w", "W", KeyCode.W, modifiers, target ), 5, 1, 2, 1 );
		root.add( createShiftableButton( "e", "E", KeyCode.E, modifiers, target ), 7, 1, 2, 1 );
		root.add( createShiftableButton( "r", "R", KeyCode.R, modifiers, target ), 9, 1, 2, 1 );
		root.add( createShiftableButton( "t", "T", KeyCode.T, modifiers, target ), 11, 1, 2, 1 );
		root.add( createShiftableButton( "z", "Z", KeyCode.Z, modifiers, target ), 13, 1, 2, 1 );
		root.add( createShiftableButton( "u", "U", KeyCode.U, modifiers, target ), 15, 1, 2, 1 );
		root.add( createShiftableButton( "i", "I", KeyCode.I, modifiers, target ), 17, 1, 2, 1 );
		root.add( createShiftableButton( "o", "O", KeyCode.O, modifiers, target ), 19, 1, 2, 1 );
		root.add( createShiftableButton( "p", "P", KeyCode.P, modifiers, target ), 21, 1, 2, 1 );
		root.add( createShiftableButton( "ü", "Ü", KeyCode.UNDEFINED, modifiers, target ), 23, 1, 2, 1 );
		root.add( createShiftableButton( "+", "*", KeyCode.PLUS, modifiers, target ), 25, 1, 2, 1 );
		root.add( createNonshiftableButton( "Enter", KeyCode.ENTER, modifiers, target ), 27, 1, 2, 2 );

		root.add( modifiers.capsLockKey(), 0, 2, 4, 1 );
		root.add( createShiftableButton( "a", "A", KeyCode.A, modifiers, target ), 4, 2, 2, 1 );
		root.add( createShiftableButton( "s", "S", KeyCode.S, modifiers, target ), 6, 2, 2, 1 );
		root.add( createShiftableButton( "d", "D", KeyCode.D, modifiers, target ), 8, 2, 2, 1 );
		root.add( createShiftableButton( "f", "F", KeyCode.F, modifiers, target ), 10, 2, 2, 1 );
		root.add( createShiftableButton( "g", "G", KeyCode.G, modifiers, target ), 12, 2, 2, 1 );
		root.add( createShiftableButton( "h", "H", KeyCode.H, modifiers, target ), 14, 2, 2, 1 );
		root.add( createShiftableButton( "j", "J", KeyCode.J, modifiers, target ), 16, 2, 2, 1 );
		root.add( createShiftableButton( "k", "K", KeyCode.K, modifiers, target ), 18, 2, 2, 1 );
		root.add( createShiftableButton( "l", "L", KeyCode.L, modifiers, target ), 20, 2, 2, 1 );
		root.add( createShiftableButton( "ö", "Ö", KeyCode.UNDEFINED, modifiers, target ), 22, 2, 2, 1 );
		root.add( createShiftableButton( "ä", "Ä", KeyCode.UNDEFINED, modifiers, target ), 24, 2, 2, 1 );
		root.add( createShiftableButton( "#", "'", KeyCode.NUMBER_SIGN, modifiers, target ), 26, 2, 1, 1 );

		root.add( modifiers.shiftKey(), 0, 3, 3, 1 );
		root.add( createShiftableButton( "<", ">", KeyCode.LESS, modifiers, target ), 3, 3, 2, 1 );
		root.add( createShiftableButton( "y", "Y", KeyCode.Y, modifiers, target ), 5, 3, 2, 1 );
		root.add( createShiftableButton( "x", "X", KeyCode.X, modifiers, target ), 7, 3, 2, 1 );
		root.add( createShiftableButton( "c", "C", KeyCode.C, modifiers, target ), 9, 3, 2, 1 );
		root.add( createShiftableButton( "v", "V", KeyCode.V, modifiers, target ), 11, 3, 2, 1 );
		root.add( createShiftableButton( "b", "B", KeyCode.B, modifiers, target ), 13, 3, 2, 1 );
		root.add( createShiftableButton( "n", "N", KeyCode.N, modifiers, target ), 15, 3, 2, 1 );
		root.add( createShiftableButton( "m", "M", KeyCode.M, modifiers, target ), 17, 3, 2, 1 );
		root.add( createShiftableButton( ",", ";", KeyCode.COMMA, modifiers, target ), 19, 3, 2, 1 );
		root.add( createShiftableButton( ".", ":", KeyCode.PERIOD, modifiers, target ), 21, 3, 2, 1 );
		root.add( createShiftableButton( "-", "_", KeyCode.MINUS, modifiers, target ), 23, 3, 2, 1 );
		root.add( modifiers.secondShiftKey(), 25, 3, 4, 1 );

		root.add( createNonshiftableButton( " ", KeyCode.SPACE, modifiers, target ), 6, 4, 18, 1 );

		for( int col = 0; col < 30; col++ ) {
			var columnConstraint = new ColumnConstraints();
			columnConstraint.setPercentWidth( 100 / 30 );
			columnConstraint.setFillWidth( true );
			root.getColumnConstraints().add( columnConstraint );
		}
		for( int row = 0; row < 5; row++ ) {
			var rowConstraint = new RowConstraints();
			rowConstraint.setPercentHeight( 100 / 5 );
			rowConstraint.setFillHeight( true );
			root.getRowConstraints().add( rowConstraint );
		}

	}

	/**
	 * Creates a VirtualKeyboard which uses the focusProperty of the scene to which
	 * it is attached as its target
	 */
	public ScreenKeyboardGerman() {
		this( null );
	}

	/**
	 * Visual component displaying this keyboard. The returned node has a style
	 * class of "virtual-keyboard". Buttons in the view have a style class of
	 * "virtual-keyboard-button".
	 * 
	 * @return a view of the keyboard.
	 */
	public Node view() {
		return root;
	}

}