package de.viguard.controller;

import java.net.URL;
import java.util.ResourceBundle;

import org.json.JSONObject;

import de.viguard.HttpHelper;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;

public class FourButtonsImageLabelController extends FXMLController implements Initializable {

	public static String a12nCode = "CgVdGENxM7tBR7RSvkA4";
	
    @FXML // ResourceBundle that was given to the FXMLLoader
    private ResourceBundle resources;

    @FXML // URL location of the FXML file that was given to the FXMLLoader
    private URL location;

	@FXML
	private Button buttonA1, buttonA2, buttonB1, buttonB2;
	
	@Override
	public void initialize( URL location, ResourceBundle resources ) {

//		if( System.getenv( "ShowControllerInititialized" ).startsWith( "true" ) ) System.out.println( this.getClass().getName() + " initialized." );
//		if( location != null ) System.out.println( "9ButtonsImageLabel - location: " + location.toExternalForm() );
//		if( resources != null )
//			resources.keySet().forEach( r -> System.out.println( r ));
		buttonBack.setDisable( false );
		buttonBack.setVisible( true );
		buttonForward.setDisable( true );
		buttonForward.setVisible( false );
	}

	@FXML
	protected void onAction( ActionEvent event ) {
		restartWatchdog();
//		System.out.println( "onAction: " + event.toString() );
		var json = new JSONObject();
		json.put( "buttonPressed", ((Button) event.getSource()).getId() );
		var postResponse = HttpHelper.post( headers.get( "node-url" ).get( 0 ), headers.get( "session-id" ).get( 0 ), json.toString( 1 ) );
//		if( System.getenv( "ShowPostResponseBody" ).startsWith( "true" ) ) System.out.println( "Post-Body: " + postResponse.body());
		if( postResponse != null && postResponse.statusCode() == 200 )
			loadAndStartNextForm( postResponse.headers().map().get( "next-id" ).get( 0 ), postResponse.headers().map().get( "next-url" ).get( 0 ) );
		else restart();
	}
}
