package de.viguard.controller;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.concurrent.Worker.State;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;

public class HelpController extends FXMLController{

	@FXML
	private WebView webView;
	private WebEngine engine;
	
	@FXML
	private void initialize() {
		engine = webView.getEngine();
		engine.getLoadWorker().stateProperty().addListener(
		        new ChangeListener<State>() {

					@Override
					public void changed( ObservableValue< ? extends State > observable, State oldValue, State newValue ) {
						System.out.println( "New State: " + newValue.toString() );
					}
		        });
		engine.load( "http://localhost/" );
//		engine.loadContent( content );
//		System.out.println( engine.getDocument().getTextContent());
	}

}
