package de.viguard.controller;

import java.net.URL;
import java.util.ResourceBundle;

import org.json.JSONObject;

import de.viguard.HttpHelper;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;

public class ImageLabelController extends FXMLController implements Initializable {

    @FXML // ResourceBundle that was given to the FXMLLoader
    private ResourceBundle resources;

    @FXML // URL location of the FXML file that was given to the FXMLLoader
    private URL location;

	@Override
	public void initialize( URL location, ResourceBundle resources ) {

//		System.out.println( this.getClass().getName() + " initialized." );
//		if( location != null ) System.out.println( "ImageLabel - location: " + location.toExternalForm() );
//		if( resources != null )
//			resources.keySet().forEach( r -> System.out.println( r ));
		buttonBack.setDisable( false );
		buttonBack.setVisible( true );
		buttonForward.setDisable( false );
		buttonForward.setVisible( true );
	}

	@Override
	protected void onForward() {
//		System.out.println( "ImageLabel: onForward" );
//		System.out.println( "Headers: " + headers.toString() );
		restartWatchdog();

		var json = new JSONObject();
		json.put( "action", "forward" );
		var postResponse = HttpHelper.post( headers.get( "node-url" ).get( 0 ), headers.get( "session-id" ).get( 0 ), json.toString( 1 ) );
//		System.out.println( "Post-Body: " + postResponse.body());
		if( postResponse != null && postResponse.statusCode() == 200 )
			loadAndStartNextForm( postResponse.headers().map().get( "next-id" ).get( 0 ), postResponse.headers().map().get( "next-url" ).get( 0 ) );
		else restart();
	}
//	@FXML
//	protected void onAction( ActionEvent event ) {
//		System.out.println( "onAction: " + event.toString() );
//		var json = new JSONObject();
//		json.put( "buttonPressed", ((Button) event.getSource()).getId() );
//		var postResponse = HttpHelper.post( headers.get( "node-url" ).get( 0 ), headers.get( "session-id" ).get( 0 ), json.toString( 1 ) );
//		System.out.println( "Post-Body: " + postResponse.body());
//
//		loadAndStartNextForm( postResponse.headers().map().get( "next-id" ).get( 0 ), postResponse.headers().map().get( "next-url" ).get( 0 ) );
//	}
}
