package de.viguard.controller;

import java.net.URL;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;

import org.json.JSONObject;

import de.viguard.HttpHelper;
import de.viguard.ScreenKeyboard.ScreenKeyboardInternationalMinimal;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.TextField;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class InputLabelKeyboardController extends FXMLController implements Initializable {

	public static String a12nCode = "CgVdGENxM7tBR7RSvkA4";
	
	private boolean isValid = false;
	
    @FXML // ResourceBundle that was given to the FXMLLoader
    private ResourceBundle resources;

    @FXML // URL location of the FXML file that was given to the FXMLLoader
    private URL location;

    @FXML
    private VBox vBox;
    
    @FXML
    private StackPane keyboard;
    
   @FXML
    private TextField input;
    
	@Override
	public void initialize( URL location, ResourceBundle resources ) {

//		System.out.println( this.getClass().getName() + " initialized." );
//		System.out.println( "Thread: " + Thread.currentThread().getName());
//		if( location != null ) System.out.println( "InputLabelKeyboard - location: " + location.toExternalForm() );
//		if( resources != null )
//			resources.keySet().forEach( r -> System.out.println( r ));

		//		var screenKeyboard = new ScreenKeyboardGerman();
	    var screenKeyboard = new ScreenKeyboardInternationalMinimal();
//	    var screenKeyboard = new ScreenKeyboardNumericPhone();
	    
	    // just add a border to easily visualize the boundary of the keyboard:
	    screenKeyboard.view().setStyle("-fx-border-color: darkblue; -fx-border-radius: 5;");
	    
	    keyboard.getChildren().add( screenKeyboard.view() );

		input.setBackground( bgInvalid );
		input.textProperty().addListener( ( observable, oldValue, newValue ) -> {
			restartWatchdog();
//			System.out.println( "" + oldValue + " " + newValue );
			var postResponse = HttpHelper.post( "/validate/reference", "none", newValue );
			if( postResponse != null )
				switch( postResponse.statusCode() ) {
					case 200:
	//					System.out.println( "Valid" );
						input.setBackground( bgValid );
						isValid = true;
						break;
					case 234:
	//					System.out.println( "Invalid" );
						input.setBackground( bgInvalid );
						isValid = false;
						break;
					default:
						restart();
						break;
				}
			else restart();
		});
//		input.focusedProperty().addListener( new ChangeListener<Boolean>() {
//			@Override
//			public void changed( ObservableValue< ? extends Boolean > observable, Boolean oldValue, Boolean newValue ) {
//				System.out.println( "Input Focus changed." );
//			}
//		});
		Timer timer = new Timer();
		timer.schedule( new TimerTask() {
			public void run() {
//				System.out.println( "Timer: " + Thread.currentThread().toString());
				timer.cancel();
				Platform.runLater( () -> input.requestFocus());
			}
		}, 1000 );
//		input.requestFocus();
		buttonBack.setDisable( false );
		buttonBack.setVisible( true );
		buttonForward.setDisable( false );
		buttonForward.setVisible( true );
	}

	@Override
	protected void onForward() {
//		System.out.println( "ImageLabelKeyboard: onForward" );
//		System.out.println( "Headers: " + headers.toString() );
		restartWatchdog();
//		if( input.getText().length() < 3 ){
//			input.setBackground( bgInvalid );
//		} else {
		if( isValid ) {
			var json = new JSONObject();
			json.put( "inputContent", input.getText() );
			var postResponse = HttpHelper.post( headers.get( "node-url" ).get( 0 ), headers.get( "session-id" ).get( 0 ), json.toString( 1 ) );
//			System.out.println( "Post-Body: " + postResponse.body());
			if( postResponse != null && postResponse.statusCode() == 200 )
				loadAndStartNextForm( postResponse.headers().map().get( "next-id" ).get( 0 ), postResponse.headers().map().get( "next-url" ).get( 0 ) );
			else restart();
		} else {
			input.setBackground( bgInvalid );
		}
	}

//	@Override
//	protected void onFake() {
//		input.setText( "12345" );
//	}
	
	@FXML
	protected void onAction( ActionEvent event ) {
//		System.out.println( "onAction: " + event.toString() ); // javafx.event.ActionEvent[source=TextField[id=input, styleClass=text-input text-field]]
		restartWatchdog();
		if( input.getText().length() < 3 ){
			input.setBackground( bgInvalid );
		} else {
			var json = new JSONObject();
	//		var textField = ((TextField) event.getSource());
//			System.out.println( "Value: " + input.getText());
			json.put( "inputContent", input.getText() );
			var postResponse = HttpHelper.post( headers.get( "node-url" ).get( 0 ), headers.get( "session-id" ).get( 0 ), json.toString( 1 ) );
//			System.out.println( "Post-Body: " + postResponse.body());
			if( postResponse != null && postResponse.statusCode() == 200 )
				loadAndStartNextForm( postResponse.headers().map().get( "next-id" ).get( 0 ), postResponse.headers().map().get( "next-url" ).get( 0 ) );
			else restart();
		}
	}
}
