package de.viguard.controller;

import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;

import javax.swing.Timer;

import de.viguard.HelpActionListener;
import de.viguard.HttpHelper;
import de.viguard.TerminalMain;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Alert.AlertType;
import javafx.scene.control.ButtonBar.ButtonData;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.stage.Screen;
import javafx.stage.Stage;

public class MainSceneController extends FXMLController implements Initializable, ActionListener {

	private static Stage primaryStage;
	
	private Dialog helpDialog;
	private Alert alert;
	
    @FXML // ResourceBundle that was given to the FXMLLoader
    private ResourceBundle resources;

    @FXML // URL location of the FXML file that was given to the FXMLLoader
    private URL location;

	@FXML
	private Button buttonEscape, buttonHelp, buttonBack, buttonForward, buttonEnd;
	
	@FXML
	private AnchorPane paneCenter;
	
	@FXML
	private Label labelCountdown, labelTitle;
	
	public Scene getScene() {
		return scene;
	}
	
	public static FXMLController createScene( Stage stage ) {
		var timer = metrics.timer( "MainScene" );
		var context = timer.time();
		primaryStage = stage;

//		ObservableList<Screen> screens = Screen.getScreens();
//		screens.forEach( screen -> System.out.println( "Screen: " + screen.toString() ) );
		
		var response = HttpHelper.get( "/start", "new" );
		if( response != null )
			if( response.statusCode() == 200 ) {
//				if( System.getenv( "ShowFormLoad" ).startsWith( "true" )) System.out.println( (String) response.body() );
				if( response.headers().map().containsKey( "session-id" ) ) {

					var fxmlLoader = new FXMLLoader();
					try {
						var contextFXMLLoader = metrics.timer( "FXMLLoader" ).time();
						Scene scene = fxmlLoader.load( new ByteArrayInputStream( ( (String) response.body() ).getBytes() ));
						contextFXMLLoader.stop();
						scene.getStylesheets().add( HttpHelper.baseURL + "/css" );
						var controller = (FXMLController) fxmlLoader.getController();
						if( controller instanceof FXMLController ) {
							controller.scene = scene;
							mainSceneController = controller;
							controller
//								.setResourcesMap( resourcesMap )
//								.setStage( stage )
								.setHeaders( response.headers().map() )
								.setSessionID( response.headers().map().get( "session-id" ).get( 0 ))
								.setNextID( response.headers().map().get( "next-id" ).get( 0 ))
								.setNextURL( response.headers().map().get( "next-url" ).get( 0 ));
						}
//						System.out.println( "Parent: " + controller.getName() );
//						stage.setTitle( "viGuard FXML" );
//						stage.setScene( scene );
////						stage.setMaximized( true );
//						stage.setFullScreenExitHint( "" );
//						stage.setFullScreen( true );
//						stage.show();
//						context.stop();
						return controller;
					} catch( IOException e ) {
						e.printStackTrace();
					}
				} else {
					System.out.println( "No Session-ID found." );
					return null;
				}
			} else {
				System.out.println( "Status-Code: " + response.statusCode() );
				return null;
			}
		return null;
	}
	
//	public Scene getScene() {
//		return scene;
//	}
//	
	@Override
	public void initialize( URL location, ResourceBundle resources ) {

//		System.out.println( this.getClass().getName() + " initialized." );
//		if( location != null ) System.out.println( "MainScene - location: " + location.toExternalForm() );
//		if( resources != null )
//			resources.keySet().forEach( r -> System.out.println( r ));
		FXMLController.centerPane = this.paneCenter;
		FXMLController.buttonBack = this.buttonBack;
		FXMLController.buttonForward = this.buttonForward;
		FXMLController.labelTitle = labelTitle;
		startWatchdog( this );
	}

	public void loadStart() {
		
		var getResponse = HttpHelper.get( firstURL, sessionID );
		if( getResponse != null && getResponse.statusCode() == 200 ) {
//			if( System.getenv( "ShowFormLoad" ).startsWith( "true" )) System.out.println( "Form: " + getResponse.body() );
			try {
				var fxmlLoader = new FXMLLoader();
//				fxmlLoader.setResources( resourcesMap.get( postResponse.headers().map().get( "next-id" ).get( 0 ) ));
//				System.out.println( "loading resources for Node-ID: " + postResponse.headers().map().get( "next-id" ).get( 0 ));
//				if( fxmlLoader.getResources() == null ) System.out.println( "Resources not found for Node-ID: " + postResponse.headers().map().get( "next-id" ).get( 0 ));
				Pane pane = fxmlLoader.load( new ByteArrayInputStream( ( (String) getResponse.body() ).getBytes()) );
	//			Scene scene = FXMLLoader.load( getClass().getClassLoader().getResource( "viGuard Form SplitPane.fxml" ));
//				scene.getStylesheets().add( stylesheet );
				var controller = (FXMLController) fxmlLoader.getController();
				if( controller instanceof FXMLController ) {
					((FXMLController) controller )
						.setResourcesMap( resourcesMap )
//						.setStage( stage )
						.setPane( pane )
						.setHeaders( getResponse.headers().map() );
					controllers.add( controller );
					activeController = controller;
					setButtons( activeController.back, activeController.forward );
				}
//				pane.setPrefWidth( 1600 );
//				pane.setPrefHeight( 900 );
				AnchorPane.setTopAnchor( pane, 0.0 );
				AnchorPane.setLeftAnchor( pane, 0.0 );
				AnchorPane.setRightAnchor( pane, 0.0 );
				AnchorPane.setBottomAnchor( pane, 0.0 );
				centerPane.getChildren().setAll( pane );
//				stage.setScene( scene );
//				stage.setMaximized( true );
//				stage.setFullScreen( true );
			} catch( IOException e ) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		} else {
			restart();
		}
	}

	public void loadHelp( Stage stage ) {
		var getResponse = HttpHelper.get( "/help", sessionID );
		if( getResponse != null && getResponse.statusCode() == 200 ) {
			System.out.println( "Form: " + getResponse.body() );
			try {
				var fxmlLoader = new FXMLLoader();
				DialogPane dialogPane = fxmlLoader.load( new ByteArrayInputStream( ( (String) getResponse.body() ).getBytes()) );
//				var controller = (FXMLController) fxmlLoader.getController();
//				if( controller instanceof FXMLController ) {
//					((FXMLController) controller )
//						.setResourcesMap( resourcesMap )
////						.setStage( stage )
//						.setPane( pane )
//						.setHeaders( getResponse.headers().map() );
//					controllers.add( controller );
//					activeController = controller;
//				}
//				stage.setScene( scene );
//				stage.setMaximized( true );
//				stage.setFullScreen( true );
				helpDialog = new Dialog();
				helpDialog.setDialogPane( dialogPane );
				helpDialog.initOwner( stage );
			} catch( IOException e ) {
				e.printStackTrace();
			}
		} else {
			restart();
		}
	}
	@FXML
	protected void onEscape( ActionEvent event ) {
//		System.out.println( "Escape Button pressed." );
		restartWatchdog();
		restart();
	}

//	@FXML
//	protected void onHelp( ActionEvent event ) {
//		System.out.println( "Help Button pressed." );
//		stopWatchdog();
//
//		var dialog = new Dialog();
//		var listener = new HelpActionListener( dialog );
//		dialog.setTitle( "Dialer" );
//		HttpHelper.post( "/sip/call", "sip", "" );
////		System.out.println( "Call command send." );
//		dialog.setHeaderText( "Init..." );
//		var timer = new Timer( 1000, listener );
//		listener.setTimer( timer );
//		timer.setRepeats( true );
//		timer.start();
//		var buttonClose = new ButtonType( "Close", ButtonData.CANCEL_CLOSE );
//		dialog.getDialogPane().getButtonTypes().addAll( buttonClose );
//		dialog.initOwner( primaryStage );
//		dialog.showAndWait();
//		timer.stop();
//		HttpHelper.post( "/sip/abort", "sip", "" );
//		startWatchdog( this );
//	}

	@FXML
	protected void onHelp( ActionEvent event ) {
//		System.out.println( "Help Button pressed." );
		if( helpController == null ) {
			var fxmlLoader = new FXMLLoader( MainSceneController.class.getClassLoader().getResource( "viGuard_Help.fxml" ));
	//		fxmlLoader.setLocation( );
			try {
				Pane pane = fxmlLoader.load();
				var controller = (FXMLController) fxmlLoader.getController();
				if( controller instanceof FXMLController ) {
		//			System.out.println( "Next Title: " + fxmlLoader.getResources().getString( "title" ));
					((FXMLController) controller )
						.setResourcesMap( resourcesMap )
						.setPane( pane )
						.setTitle( "Help" );
	//				controllers.add( controller );
					helpController = controller;
					lastActiveController = activeController;
//					System.out.println( "Active Controller: " + activeController.toString() );
					activeController = controller;
				}
				AnchorPane.setTopAnchor( pane, 0.0 );
				AnchorPane.setLeftAnchor( pane, 0.0 );
				AnchorPane.setRightAnchor( pane, 0.0 );
				AnchorPane.setBottomAnchor( pane, 0.0 );
				setButtons( helpController.back, helpController.forward );
				Platform.runLater( () -> centerPane.getChildren().setAll( pane ));
			} catch( IOException e ) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		} else {
			lastActiveController = activeController;
//			System.out.println( "Active Controller: " + activeController.toString() );
			activeController = helpController;
			setButtons( helpController.back, helpController.forward );
			Platform.runLater( () -> centerPane.getChildren().setAll( helpController.pane ));
		}
	}
	
	@FXML
	protected void onBack( ActionEvent event ) {
//		System.out.println( "Back Button pressed." );
		restartWatchdog();
//		System.out.println( "Controllers: " + controllers.toString() );
		if( activeController == helpController ) {
			labelTitle.setText( lastActiveController.getTitle() );
			activeController = lastActiveController;
			setButtons( activeController.back, activeController.forward );
			centerPane.getChildren().setAll( lastActiveController.pane );
		} else {
			if( controllers.contains( activeController )) {
				var iterator = controllers.listIterator( controllers.indexOf( activeController ));
				if( iterator.hasPrevious() ) System.out.println( "Iterator previous: " + iterator.previousIndex());
				if( iterator.hasNext() ) System.out.println( "Iterator next: " + iterator.nextIndex());
				if( iterator.hasPrevious() ) {
					var controller = iterator.previous();
					System.out.println( "Previous Title: " + controller.getTitle());
					labelTitle.setText( controller.getTitle() );
					controllers.remove( activeController );
					activeController = controller;
					setButtons( activeController.back, activeController.forward );
					centerPane.getChildren().setAll( controller.pane );
	//				labelTitle.setText( this.getTitle( ));
				}
			}
		}
//		if( controllers.listIterator().hasPrevious() )
//			centerPane.getChildren().setAll( controllers.listIterator().previous().pane );
	}
	
	@FXML
	protected void onForward( ActionEvent event ) {
//		System.out.println( "Forward Button pressed." );
		restartWatchdog();
//		setButtons( activeController.back, activeController.forward );
		activeController.onForward();
	}
	
	@FXML
	protected void onEnd( ActionEvent event ) {
//		stopWatchdog();
//		Platform.exit();
	}
	
	@FXML
	protected void onFake( MouseEvent event ) {
//		System.out.println( "Fake pressed." );
		restartWatchdog();
		activeController.onFake();
	}
	
	public MainSceneController setNextID( String nextID ) {
		this.nextID = nextID;
		firstID = nextID;
		return this;
	}
	
	public FXMLController setNextURL( String nextURL ) {
		this.nextURL = nextURL;
		firstURL = nextURL;
		return this;
	}
	
	@Override
	public void actionPerformed( java.awt.event.ActionEvent e ) {
		if( --countdown > 0 ) {
			System.out.println( "MainScene Rest: " + countdown );
			Platform.runLater( () -> labelCountdown.setText( "" + countdown ));
//			System.out.println( "Focus: " + scene.getFocusOwner().toString() );
		} else {
			System.out.println( "MainScene Timeout!" + countdown );
//			watchdogTimer.stop();
			if( alert != null ) Platform.runLater( () -> alert.close());
			restart();
			restartWatchdog();
		}
	}
}
