/*
 * Decompiled with CFR 0.152.
 */
package de.viguard;

import de.viguard.Signature;
import java.util.ArrayList;
import javafx.application.Application;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class CanvasMain
extends Application {
    public static void main(String[] args) {
        CanvasMain.launch((String[])args);
    }

    public void start(Stage stage) throws Exception {
        Signature signature = new Signature(600, 200);
        Group root = new Group();
        Canvas canvas = new Canvas(600.0, 200.0);
        GraphicsContext context = canvas.getGraphicsContext2D();
        context.setFill((Paint)Color.BLACK);
        context.setStroke((Paint)Color.BLACK);
        context.setLineWidth(2.0);
        canvas.addEventHandler(MouseEvent.MOUSE_PRESSED, e -> signature.startSegment(new Point2D(e.getX(), e.getY())));
        canvas.addEventHandler(MouseEvent.MOUSE_DRAGGED, e -> {
            signature.addPoint(new Point2D(e.getX(), e.getY()));
            context.clearRect(0.0, 0.0, canvas.getWidth(), canvas.getHeight());
            ArrayList<Signature.Segment> segments = signature.getSegments();
            segments.forEach(segment -> {
                context.beginPath();
                context.moveTo(segment.getStart().getX(), segment.getStart().getY());
                segment.getPoints().forEach(point -> context.lineTo(point.getX(), point.getY()));
                context.stroke();
            });
        });
        canvas.addEventHandler(MouseEvent.MOUSE_RELEASED, e -> {
            signature.endSegment();
            System.out.println(signature.getSVG());
        });
        root.getChildren().add((Object)canvas);
        stage.setScene(new Scene((Parent)root));
        stage.show();
    }
}

