/*
 * Decompiled with CFR 0.152.
 */
package de.viguard;

import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;

public class HttpHelper {
    public static String baseURL = "http://localhost:1881";
    private static String authCode = "UnuKJZzH7JPbp8pYvK9H";

    public static HttpResponse get(String url, String sessionID) {
        try {
            System.out.println("GET: " + baseURL + url + " with SessionID: " + sessionID);
            HttpRequest httpRequest = HttpRequest.newBuilder(new URI(baseURL + url)).version(HttpClient.Version.HTTP_1_1).header("Authentication-Code", authCode).header("Session-ID", sessionID).GET().timeout(Duration.ofSeconds(10L)).build();
            HttpClient httpClient = HttpClient.newBuilder().build();
            HttpResponse<String> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            System.out.println("Status: " + httpResponse.statusCode());
            System.out.println("Headers:");
            httpResponse.headers().map().forEach((k, v) -> System.out.println(k + ": " + String.valueOf(v)));
            return httpResponse;
        }
        catch (ConnectException e) {
            System.out.println("no connection.");
            return null;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static HttpResponse post(String url, String sessionID, String body) {
        try {
            System.out.println("POST: " + baseURL + url + " with SessionID: " + sessionID);
            System.out.println("Body: " + body);
            HttpRequest httpRequest = HttpRequest.newBuilder(new URI(baseURL + url)).version(HttpClient.Version.HTTP_1_1).header("Authentication-Code", authCode).header("Session-ID", sessionID).POST(HttpRequest.BodyPublishers.ofString(body)).timeout(Duration.ofSeconds(10L)).build();
            HttpClient httpClient = HttpClient.newBuilder().build();
            HttpResponse<String> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            System.out.println("Status: " + httpResponse.statusCode());
            httpResponse.headers().map().forEach((k, v) -> System.out.println(k + ": " + String.valueOf(v)));
            return httpResponse;
        }
        catch (ConnectException e) {
            System.out.println("no connection.");
            return null;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static HttpResponse put(String url, String body) {
        try {
            System.out.println("PUT: " + baseURL + url);
            HttpRequest httpRequest = HttpRequest.newBuilder(new URI(baseURL + url)).version(HttpClient.Version.HTTP_1_1).header("Authentication-Code", authCode).header("package", "com.viGuard").PUT(HttpRequest.BodyPublishers.ofString(body)).build();
            HttpClient httpClient = HttpClient.newBuilder().build();
            HttpResponse<String> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            System.out.println("Status: " + httpResponse.statusCode());
            httpResponse.headers().map().forEach((k, v) -> System.out.println(k + ": " + String.valueOf(v)));
            return httpResponse;
        }
        catch (ConnectException e) {
            System.out.println("no connection.");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static HttpResponse delete(String url) {
        try {
            System.out.println("DELETE: " + baseURL + url);
            HttpRequest httpRequest = HttpRequest.newBuilder(new URI(baseURL + url)).version(HttpClient.Version.HTTP_1_1).header("Authentication-Code", authCode).header("package", "com.viGuard").DELETE().build();
            HttpClient httpClient = HttpClient.newBuilder().build();
            HttpResponse<String> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            System.out.println("Status: " + httpResponse.statusCode());
            httpResponse.headers().map().forEach((k, v) -> System.out.println(k + ": " + String.valueOf(v)));
            return httpResponse;
        }
        catch (ConnectException e) {
            System.out.println("no connection.");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static HttpResponse putPNG(String setID, String themeID, String imageID, String body) {
        try {
            System.out.println("PUT: " + baseURL + "/png/" + imageID);
            HttpRequest httpRequest = HttpRequest.newBuilder(new URI(baseURL + "/png/" + imageID)).version(HttpClient.Version.HTTP_1_1).header("Authentication-Code", authCode).header("Image-ID", imageID).header("Set-ID", setID).header("Theme-ID", themeID).PUT(HttpRequest.BodyPublishers.ofString(body)).build();
            HttpClient httpClient = HttpClient.newBuilder().build();
            HttpResponse<String> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            System.out.println("Status: " + httpResponse.statusCode());
            httpResponse.headers().map().forEach((k, v) -> System.out.println(k + ": " + String.valueOf(v)));
            return httpResponse;
        }
        catch (ConnectException e) {
            System.out.println("no connection.");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return null;
    }
}

