/*
 * Decompiled with CFR 0.152.
 */
package de.viguard;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import de.viguard.HttpHelper;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class HttpReporter
extends ScheduledReporter {
    public HttpReporter(MetricRegistry registry) {
        super(registry, "http-reporter", MetricFilter.ALL, TimeUnit.SECONDS, TimeUnit.MILLISECONDS);
    }

    @Override
    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        JSONObject json = new JSONObject();
        if (!meters.isEmpty()) {
            JSONObject jsonMeters = new JSONObject();
            for (Map.Entry<String, Metered> entry : meters.entrySet()) {
                jsonMeters.put(entry.getKey(), entry.getValue());
            }
            json.put("meters", jsonMeters);
        }
        if (!timers.isEmpty()) {
            JSONObject jsonTimers = new JSONObject();
            for (Map.Entry<String, Metered> entry : timers.entrySet()) {
                jsonTimers.put(entry.getKey(), ((Timer)entry.getValue()).getSnapshot().getMean());
            }
            json.put("timers", jsonTimers);
        }
        HttpHelper.post("/metrics", "metrics", json.toString(1));
    }
}

