/*
 * Decompiled with CFR 0.152.
 */
package de.viguard.controller;

import com.codahale.metrics.MetricRegistry;
import de.viguard.HttpHelper;
import de.viguard.PropertiesResourceBundle;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javax.swing.Timer;

public class FXMLController {
    private int defaultCountdown = 300;
    private int retryTimeout = 1;
    protected static final MetricRegistry metrics = new MetricRegistry();
    protected static volatile Map<String, PropertiesResourceBundle> resourcesMap = new HashMap<String, PropertiesResourceBundle>();
    protected static String sessionID;
    protected static String firstID;
    protected static String firstURL;
    protected static AnchorPane centerPane;
    protected static Button buttonBack;
    protected static Button buttonForward;
    protected static Label title;
    protected static volatile int countdown;
    protected static final LinkedList<FXMLController> controllers;
    protected static volatile FXMLController activeController;
    protected static volatile FXMLController mainSceneController;
    protected static volatile FXMLController outOfOrderController;
    protected static final Background bgInvalid;
    protected static final Background bgValid;
    protected Timer watchdogTimer;
    protected Map<String, List<String>> headers;
    protected String nodeID;
    protected String nextID;
    protected String nodeURL;
    protected String nextURL;
    protected Stage stage;
    protected Scene scene;
    protected Pane pane;

    static {
        controllers = new LinkedList();
        bgInvalid = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.YELLOW, null, null)});
        bgValid = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.LIGHTGREEN, null, null)});
    }

    public void show() {
        this.stage.setTitle("viGuard FXML");
        this.stage.setScene(this.getScene());
        this.stage.setFullScreenExitHint("");
        this.stage.setFullScreen(true);
        this.stage.show();
    }

    public void startWatchdog(int timeout) {
        this.startWatchdog(timeout, (ActionListener)((Object)this));
    }

    public void startWatchdog(ActionListener listener) {
        this.startWatchdog(this.defaultCountdown, listener);
    }

    public void startWatchdog(int timeout, ActionListener listener) {
        this.defaultCountdown = timeout;
        countdown = timeout;
        if (this.watchdogTimer == null) {
            this.watchdogTimer = new Timer(1000, listener);
        }
        this.watchdogTimer.setRepeats(true);
        this.watchdogTimer.start();
    }

    public void stopWatchdog() {
        System.out.println("Stopping watchdog");
        this.watchdogTimer.stop();
    }

    public void restartWatchdog() {
        this.restartWatchdog(this.defaultCountdown);
    }

    public void restartWatchdog(int timeout) {
        countdown = timeout;
    }

    public MetricRegistry getMetrics() {
        return metrics;
    }

    public Map<String, PropertiesResourceBundle> getResourcesMap() {
        return resourcesMap;
    }

    public FXMLController setResourcesMap(Map<String, PropertiesResourceBundle> resourcesMap) {
        FXMLController.resourcesMap = resourcesMap;
        return this;
    }

    public FXMLController setSessionID(String sessionID) {
        FXMLController.sessionID = sessionID;
        return this;
    }

    public FXMLController setCenterPane(AnchorPane pane) {
        centerPane = pane;
        return this;
    }

    public FXMLController setPane(Pane pane) {
        this.pane = pane;
        return this;
    }

    public FXMLController setNodeID(String nodeID) {
        this.nodeID = nodeID;
        return this;
    }

    public FXMLController setNodeURL(String nodeURL) {
        this.nodeURL = nodeURL;
        return this;
    }

    public FXMLController setNextID(String nextID) {
        this.nextID = nextID;
        return this;
    }

    public FXMLController setNextURL(String nextURL) {
        this.nextURL = nextURL;
        return this;
    }

    public FXMLController setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
        if (headers.containsKey("session-id")) {
            sessionID = headers.get("session-id").get(0);
        }
        return this;
    }

    public Stage getStage() {
        return this.stage;
    }

    public FXMLController setStage(Stage stage) {
        this.stage = stage;
        return this;
    }

    public Scene getScene() {
        return this.scene;
    }

    public FXMLController setScene(Scene scene) {
        this.scene = scene;
        return this;
    }

    protected void restart() {
        try {
            Thread.sleep(this.retryTimeout * 1000);
            if (this.retryTimeout < 100) {
                this.retryTimeout *= 2;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        controllers.clear();
        HttpResponse response = HttpHelper.get("/start", "new");
        if (response != null) {
            if (response.statusCode() == 200) {
                if (response.headers().map().containsKey("session-id")) {
                    this.setHeaders(response.headers().map()).setSessionID(response.headers().map().get("session-id").get(0)).setNextID(response.headers().map().get("next-id").get(0)).setNextURL(response.headers().map().get("next-url").get(0));
                }
                this.retryTimeout = 1;
                this.loadAndStartNextForm(response.headers().map().get("next-id").get(0), response.headers().map().get("next-url").get(0));
            }
        } else {
            mainSceneController.stopWatchdog();
            outOfOrderController.startWatchdog(5);
            Platform.runLater(() -> outOfOrderController.show());
        }
    }

    protected void loadAndStartNextForm(String nextID, String nextURL) {
        HttpResponse getResponse = HttpHelper.get(nextURL, sessionID);
        if (getResponse != null && getResponse.statusCode() == 200) {
            System.out.println("Form: " + String.valueOf(getResponse.body()));
            try {
                FXMLLoader fxmlLoader = new FXMLLoader();
                fxmlLoader.setResources((ResourceBundle)resourcesMap.get(nextID));
                System.out.println("loading resources for Node-ID: " + nextID);
                if (fxmlLoader.getResources() == null) {
                    System.out.println("Resources not found for Node-ID: " + nextID);
                } else if (fxmlLoader.getResources().containsKey("title")) {
                    title.setText(fxmlLoader.getResources().getString("title"));
                } else {
                    title.setText("viGuard Terminal");
                }
                Pane pane = (Pane)fxmlLoader.load((InputStream)new ByteArrayInputStream(((String)getResponse.body()).getBytes()));
                FXMLController controller = (FXMLController)fxmlLoader.getController();
                if (controller instanceof FXMLController) {
                    controller.setResourcesMap(resourcesMap).setPane(pane).setHeaders(getResponse.headers().map());
                    controllers.add(controller);
                    activeController = controller;
                }
                AnchorPane.setTopAnchor((Node)pane, (Double)0.0);
                AnchorPane.setLeftAnchor((Node)pane, (Double)0.0);
                AnchorPane.setRightAnchor((Node)pane, (Double)0.0);
                AnchorPane.setBottomAnchor((Node)pane, (Double)0.0);
                Platform.runLater(() -> {
                    boolean bl = centerPane.getChildren().setAll((Object[])new Node[]{pane});
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.restart();
        }
    }

    protected void onActivate() {
    }

    protected void onForward() {
    }

    protected void onFake() {
    }
}

