/*
 * Decompiled with CFR 0.152.
 */
package de.viguard.controller;

import de.viguard.HttpHelper;
import de.viguard.ScreenKeyboard.ScreenKeyboardInternationalMinimal;
import de.viguard.controller.FXMLController;
import java.net.URL;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.TextField;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.json.JSONObject;

public class InputLabelKeyboardController
extends FXMLController
implements Initializable {
    public static String a12nCode = "CgVdGENxM7tBR7RSvkA4";
    private boolean isValid = false;
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private VBox vBox;
    @FXML
    private StackPane keyboard;
    @FXML
    private TextField input;

    public void initialize(URL location, ResourceBundle resources) {
        ScreenKeyboardInternationalMinimal screenKeyboard = new ScreenKeyboardInternationalMinimal();
        screenKeyboard.view().setStyle("-fx-border-color: darkblue; -fx-border-radius: 5;");
        this.keyboard.getChildren().add((Object)screenKeyboard.view());
        this.input.setBackground(bgInvalid);
        this.input.textProperty().addListener((observable, oldValue, newValue) -> {
            this.restartWatchdog();
            HttpResponse postResponse = HttpHelper.post("/validate/reference", "none", newValue);
            if (postResponse != null) {
                switch (postResponse.statusCode()) {
                    case 200: {
                        this.input.setBackground(bgValid);
                        this.isValid = true;
                        break;
                    }
                    case 234: {
                        this.input.setBackground(bgInvalid);
                        this.isValid = false;
                        break;
                    }
                    default: {
                        this.restart();
                        break;
                    }
                }
            } else {
                this.restart();
            }
        });
        final Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                timer.cancel();
                Platform.runLater(() -> InputLabelKeyboardController.this.input.requestFocus());
            }
        }, 1000L);
        buttonBack.setDisable(false);
        buttonBack.setVisible(true);
        buttonForward.setDisable(false);
        buttonForward.setVisible(true);
    }

    @Override
    protected void onForward() {
        this.restartWatchdog();
        if (this.isValid) {
            JSONObject json = new JSONObject();
            json.put("inputContent", this.input.getText());
            HttpResponse postResponse = HttpHelper.post((String)((List)this.headers.get("node-url")).get(0), (String)((List)this.headers.get("session-id")).get(0), json.toString(1));
            if (postResponse != null && postResponse.statusCode() == 200) {
                this.loadAndStartNextForm(postResponse.headers().map().get("next-id").get(0), postResponse.headers().map().get("next-url").get(0));
            } else {
                this.restart();
            }
        } else {
            this.input.setBackground(bgInvalid);
        }
    }

    @FXML
    protected void onAction(ActionEvent event) {
        this.restartWatchdog();
        if (this.input.getText().length() < 3) {
            this.input.setBackground(bgInvalid);
        } else {
            JSONObject json = new JSONObject();
            json.put("inputContent", this.input.getText());
            HttpResponse postResponse = HttpHelper.post((String)((List)this.headers.get("node-url")).get(0), (String)((List)this.headers.get("session-id")).get(0), json.toString(1));
            if (postResponse != null && postResponse.statusCode() == 200) {
                this.loadAndStartNextForm(postResponse.headers().map().get("next-id").get(0), postResponse.headers().map().get("next-url").get(0));
            } else {
                this.restart();
            }
        }
    }
}

