/*
 * Decompiled with CFR 0.152.
 */
package de.viguard.distribution;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import de.viguard.HttpHelper;
import de.viguard.distribution.PictureGenerator;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.stream.Stream;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;

public class GeneratePNGs
extends PictureGenerator {
    static String basePath = "./src/main/resources/icons/";

    public static void main(String[] args) {
        if (args.length == 1) {
            HttpHelper.baseURL = args[0];
        }
        DefaultMustacheFactory mustacheFactory = new DefaultMustacheFactory();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Stream<Path> stream = Files.walk(Paths.get(basePath, new String[0]), new FileVisitOption[0]);){
                stream.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(path -> path.getFileName().toString().endsWith(".svgt")).forEach(path -> {
                    System.out.println(path.toString());
                    String setID = path.toString().replaceFirst(basePath, "").replace("/" + path.getFileName().toString(), "");
                    String imageID = path.getFileName().toString().replace(".svgt", "");
                    System.out.println("Set: " + setID + " Image: " + imageID);
                    try {
                        Throwable throwable = null;
                        Object var5_8 = null;
                        try (FileReader fileReader = new FileReader(path.toString());){
                            Mustache mustache = mustacheFactory.compile(fileReader, path.getFileName().toString());
                            themes.forEach((name, theme) -> {
                                try {
                                    StringWriter writer = new StringWriter();
                                    mustache.execute((Writer)writer, theme).flush();
                                    String imageBase64 = GeneratePNGs.convertSVGtoPNG(writer.toString());
                                    HttpHelper.putPNG(setID, name, imageID, imageBase64);
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            });
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public static void convertSVGtoPNGFile(String svg, String filename) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            TranscoderInput input = new TranscoderInput(new StringReader(svg));
            TranscoderOutput output = new TranscoderOutput(Files.newOutputStream(Path.of(filename, new String[0]), new OpenOption[0]));
            PNGTranscoder transcoder = new PNGTranscoder();
            transcoder.transcode(input, output);
        }
        catch (TranscoderException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String convertSVGtoPNG(String svg) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            TranscoderInput input = new TranscoderInput(new StringReader(svg));
            TranscoderOutput output = new TranscoderOutput(outputStream);
            PNGTranscoder transcoder = new PNGTranscoder();
            transcoder.transcode(input, output);
            return Base64.getEncoder().encodeToString(outputStream.toByteArray());
        }
        catch (TranscoderException e) {
            e.printStackTrace();
            return null;
        }
    }
}

